const util = require('../../../utils/util.js')

/* 手机 验证码 相关内容 */
const BindPhone = {
  popupShow: function (res) { this.tempUserInfo = res.userInfo; this.setData({ 'bindphone.isShow': "on" }); },
  /* 关闭 绑定 弹窗 */
  popupClose: function () { 
    !(wx.getStorageSync('userInfo') || {}).nickName && wx.setStorageSync('userSession', {}); 
    clearInterval(this.timer); // 关闭定时器
    let bindphone = { isShow: '', getCode: true, countDown: 60, phone: '', code: '' }
    this.setData({ 'bindphone': bindphone })
    /* 账号弹框关闭，也用这个方法 */
    let bindaccount = { isShow: '', account: '', pwd: '' }
    this.setData({ 'bindaccount': bindaccount })
  },
  /* 跳转 账号登录 */
  accountLogin: function () { this.setData({ 'bindphone.isShow': "off" }); this.setData({ 'bindaccount.isShow': "on" }); },
  /* 电话输入 离开 input blur事件监听 */
  inputPhone: function (e) { this.setData({ 'bindphone.phone': e.detail.value }); },
  /* 验证码输入 离开 input blur事件监听 */
  inputCode: function (e) { this.setData({ 'bindphone.code': e.detail.value }); },
  /* 点击获取验证码 */
  getCode: function () {  
    const _that = this, _bind = _that.data.bindphone;
    if (!_bind.phone || !/^1[3-9][0-9]{9}$/.test(_bind.phone)) { wx.showToast({ title: '请填入正确手机号', icon: 'none', duration: 1500 }); return; }
    wx.showToast({ title: '验证码请求中', icon: 'none' })
      wx.request({
        url: util.config.URL_PATH2 + '/user_center/send_login_code',
        data: { mobile: _bind.phone, service: 'applet.ezijing.com' }, method: 'POST', header: { tenant: util.config.tenant }, 
        success: function (res) {
          if (res.statusCode != 200) { wx.showToast({ title: res.data.message, icon: 'none' }); return ; }
          wx.hideToast()
          _that.setData({ 'bindphone.getCode': false })
          /* 增加定时器 */
          _that.timer = setInterval(() => {
            if (_bind.countDown == 0) { clearInterval(_that.timer); _that.setData({ 'bindphone.countDown': 60, 'bindphone.getCode': true }); return; }
            _that.setData({ 'bindphone.countDown': _bind.countDown - 1 });
          }, 1000)
        },
        fail: function (res) { wx.hideToast(); wx.showToast({ title: res, icon: 'none' }); }
      })
  },
  /* 点击确定 */
  codeConfirm: function (e) {
    const _that = this, _bind = _that.data.bindphone
    if (!_bind.phone || !/^1[3-9][0-9]{9}$/.test(_bind.phone)) { wx.showToast({ title: '请填入正确手机号', icon: 'none' }); return ; }
    if (!_bind.code || !/^\d{4}$/.test(_bind.code)) { wx.showToast({ title: '请填入正确验证码', icon: 'none' }); return ; }
    wx.showToast({ title: '验证中', icon: 'none' })
    /* 调用接口 - 使用验证码登录 */
    wx.request({
      url: util.config.URL_PATH2 + '/user_center/code_login',
      data: { mobile: _bind.phone, code: _bind.code, service: 'applet.ezijing.com' }, method: 'POST', header: { token: wx.getStorageSync('userSession').sessionKey, tenant: util.config.tenant }, 
      success: function (res) {
        if (res.statusCode && res.statusCode != 200) { wx.showToast({ title: res.data.message, icon: 'none' }); return ; }
        wx.hideToast()
        clearInterval(_that.timer);
        /* 获取用户信息 */
        wx.request({
          url: util.config.URL_PATH1 + '/user/check-access',
          data: {}, method: 'GET', header: {
            token: wx.getStorageSync('userSession').sessionKey,
            tenant: util.config.tenant
          },
          success: res => { 
            if (res.statusCode != 200) { wx.showToast({ title: res.data.message, icon: 'none' });  return; }
            let _userInfo = {
              avatarUrl: res.data.avatar || _that.tempUserInfo.avatarUrl || '无',
              nickName: res.data.nickname || _that.tempUserInfo.nickName || '无'
            }
            wx.setStorageSync('userInfo', _userInfo);
            _that.setData({ userInfo: _userInfo, hasUserInfo: true })
            _that.popupClose()
            _that.goOutSite()
          }
        })
      },
      fail: function (res) { wx.hideToast(); wx.showToast({ title: res, icon: 'none' }); }
    })
  }
}

module.exports = {
  BindPhone: BindPhone,
}