//index.js
//获取应用实例
const app = getApp()
const util = require('../../utils/util.js')
const BindPhone = require('./bindPhone/bindPhone.js')
const BindAccount = require('./bindAccount/bindAccount.js')

Page({
  data: {
    motto: '点击进入学习系统',
    userInfo: {},
    hasUserInfo: false,
    canIUse: wx.canIUse('button.open-type.getUserInfo'),
    // 绑定手机号 相关
    bindphone: { isShow: '', getCode: true, countDown: 60, phone: '', code: '' },
    // 绑定账号 相关
    bindaccount: { isShow: '', account: '', pwd: '' },
    // 是否 可以使用登录
    isUseAccountLogin: true
  },
  goOutSite: function () {
    // wx.navigateTo({
    //   url: '/pages/outSite/outSite'
    // })
    wx.switchTab({
      url: '/pages/learnSystem/home/home'
    })
  },
  /* 进入页面，先判断是否获取用户信息 */
  onReady: function () {
    /* 判别 是否显示 账号登录 */
    wx.request({
      url: util.config.URL_PATH1 + '/switch/lock',
      data: {}, method: 'GET', header: { tenant: util.config.tenant, apikey: '1pzy3FOYTQk7171FElDfaCuGrJZ9r7sT' }, success: res => {
        this.setData({ 'isUseAccountLogin': res.data.switch })
        wx.setStorageSync('isUseAccountLogin', res.data.switch)
      }
    })
    wx.hideLoading();
  },
  // e.detail.userInfo,
  /* 按键授权，微信新版 - 获取用户信息 - 授权方式 */
  getUserInfo: function (e) { this.getInfo() },
  /* 获取用户信息 并 判别是否跟紫荆账号绑定 */
  getInfo: function () {
    wx.showLoading({ title: '信息获取中...', mask: true })
    /* 判别是否登录或者登录过期 */
    util.LoginAgainAndJumpPage((loginRes, res) => {
      if (loginRes) {
        /* 只要调用登录接口，就返回sessionKey, 如果没有绑定 直接 全部 不再使用skey 改为 token */
        wx.setStorageSync('userSession', { sessionKey: loginRes.data.ticket })
        wx.setStorageSync('userInfo', {})
        if (loginRes.data && loginRes.data.error_code == 40030) {
          /* 判别 是否绑定过 紫荆账号 */
          this.popupShow(res); wx.hideLoading(); return;
        } else if (loginRes.data && loginRes.data.status && loginRes.data.status != 200) {
          wx.hideLoading(); wx.showToast({ title: loginRes.data.message, icon: 'none' }); return;
        } else if (loginRes.statusCode != 200) {
          wx.hideLoading(); wx.showToast({ title: loginRes.data.message, icon: 'none' }); return;
        } else {
          let _userInfo = {
            avatarUrl: loginRes.data.avatar || res.userInfo.avatarUrl || '无',
            nickName: loginRes.data.nickname || res.userInfo.nickName || '无'
          }
          wx.setStorageSync('userInfo', _userInfo);
          this.setData({ userInfo: _userInfo, hasUserInfo: true })
          wx.hideLoading(); this.goOutSite(); return;
        }
        // if (res.data.errorCode == 40029) return _that.animteHint("code错误");
      } else {
        this.setData({ userInfo: wx.getStorageSync('userInfo'), hasUserInfo: true })
        wx.hideLoading(); this.goOutSite(); return;
      }
    })
  },
  guestLogin: function () {
    wx.showModal({
      title: '提示', content: '本账户只适用于“体验学习”，正式学习请点击“登录”按钮',
      success: (res) => {
        if (res.confirm) {
          wx.setStorageSync('userInfo', { "avatarUrl": "https://wx.qlogo.cn/mmopen/vi_32/Q0j4TwGTfTJv5HunMDDhpdaTz7aVXniaeOUxyQxwa9clFnJCm7Y8eP8gbUkF7I9NHSXSDJ1KssdYw9vAKb0v8fQ/132", "nickName": "游客账号" });
          wx.setStorageSync('userSession', { "sessionKey": "" });
          this.goOutSite();
        }
      }
    });
  },
  /* 手机号绑定 方法 */
  accountLogin: BindPhone.BindPhone.accountLogin,
  timer: BindPhone.BindPhone.timer,
  popupShow: BindPhone.BindPhone.popupShow,
  popupClose: BindPhone.BindPhone.popupClose,
  inputPhone: BindPhone.BindPhone.inputPhone,
  inputCode: BindPhone.BindPhone.inputCode,
  getCode: BindPhone.BindPhone.getCode,
  codeConfirm: BindPhone.BindPhone.codeConfirm,
  /* 账号绑定 方法 */
  phoneLogin: BindAccount.BindAccount.phoneLogin,
  inputAccount: BindAccount.BindAccount.inputAccount,
  inputPwd: BindAccount.BindAccount.inputPwd,
  accountConfirm: BindAccount.BindAccount.accountConfirm
})
