/**
 * 所有相关配置项
 */
const config = {
  // URL_PATH: 'http://dev.ezijing.com:3000/api', // 本地开发域名
  // outSiteLink: 'https://applets.ezijing.com', // 本地测试外链
  // URL_PATH: 'https://api2.ezijing.com', // 测试域名
  // outSiteLink: 'https://kelley2.ezijing.com', // 测试外链
  URL_PATH: 'https://api.ezijing.com/tenant', // 正式域名 - 由于项目变动域名
  URL_PATH1: 'https://lms-api.ezijing.com', // 正式域名 - 由于项目变动域名
  URL_PATH2: 'https://sso.ezijing.com', // 正式域名 - 由于项目变动域名
  outSiteLink: 'https://e-learning.ezijing.com', // 正式外链
  tenant: 'collage'
}
/* 请求接口统一 重定义 */
const requestApi = (obj) => {
  wx.request({
    url: obj.url,
    data: obj.data || '', // 不必填
    header: {
      'token': wx.getStorageSync('userSession').sessionKey,
      'tenant': config.tenant,
      'content-type': 'application/x-www-form-urlencoded',
      'apikey': '1pzy3FOYTQk7171FElDfaCuGrJZ9r7sT'
    },
    method: obj.method || 'GET', // 不必填，默认 GET
    dataType: 'json',
    success: function (res) {
      if (res.statusCode === 200) { 
        // if (res.data.status === 200) {
        //   obj.callback(res.data) // 直接把数据处理好，然后直接 返回 
        // } else {
        //   wx.showToast({ title: JSON.stringify(res.data), icon: 'none' }) // 自己后台封装返回
        // }
        obj.callback(res)
      } else if (res.statusCode === 403 || res.statusCode === 401) {
        /* 未授权登录，跳转首页 */
        wx.reLaunch({
          url: '/pages/index/index'
        })
      } else {
        wx.showToast({ title: res.errMsg, icon: 'none' }) // 微信封装返回
      }
    },
    fail: function (res) {
      wx.showToast({ title: JSON.stringify(res), icon: 'none' })
    }
  })
}
/* 工具方法 - 播放时间 转化 h:m:s */
const durationToTimeString = (duration) => {
  let h = Math.floor(duration / 3600);
  let m = Math.floor((duration - h * 3600) / 60);
  let s = (duration - h * 3600 - m * 60) % 60;
  function tenify(a) {
    return a >= 10 ? a : '0' + a;
  }
  let to = { h: tenify(h), m: tenify(m), s: tenify(s) }
  let format = 'h:m:s';
  return format.replace(/h|m|s/g, k => to[k]).replace(/^00\:/, '');
}

/**
 * 小程序 - 获取用户信息
 */
const miniGetInfo = (callback) => {
  // 获取用户凭证code - 使用 login API获取
  wx.login({
    success: res => {
      let obj = {}
      obj.code = res.code
      // 获取用户授权设置 - 使用 getSetting API获取
      wx.getSetting({
        success: res1 => {
          if (res1.authSetting['scope.userInfo']) {
            // 获取用户信息 - 使用 getUserInfo API获取
            wx.getUserInfo({
              withCredentials: true,
              success: res2 => {
                obj.encryptedData = res2.encryptedData
                obj.iv = res2.iv
                obj.userInfo = res2.userInfo
                /**
                 * 这里 调用后台接口 loginApi，传参如下
                 * obj.code
                 * obj.encryptedData
                 * obj.iv
                 * obj.userInfo
                 */
                loginApi(obj, (res, obj) => { callback(res, obj); })
              },
              fail: res2 => { wx.hideLoading(); wx.showToast({ title: '用户信息获取失败，请重试', icon: 'none' }); }
            })
          } else {
            wx.hideLoading(); wx.showToast({ title: '请先点击登录', icon: 'none' });
          }
        },
        fail: res1 => { wx.hideLoading(); wx.showToast({ title: '用户授权设置获取失败，请重试', icon: 'none' }); }
      })
    },
    fail: res => { wx.hideLoading(); wx.showToast({ title: '用户凭证code获取失败，请重试', icon: 'none' }); }
  })
}

/**
 * 登录api - 获取 openId 、userName等内容
 */
const loginApi = (obj, callback) => {
  wx.request({
    url: config.URL_PATH1 + '/user/check-unionid', 
    data: { code: obj.code, encrypted_data: obj.encryptedData, iv: obj.iv }, method: 'POST', header: {
      tenant: config.tenant,
      apikey: '1pzy3FOYTQk7171FElDfaCuGrJZ9r7sT'
    }, 
    success: res => {
      if (res.statusCode == 200) {
        wx.request({
          url: config.URL_PATH2 + '/user_center/wechat_login', 
          data: { wechat_unionid: res.data.union_id, service: 'applet.ezijing.com' }, method: 'POST', header: {
            'tenant': config.tenant,
            'content-type': 'application/x-www-form-urlencoded',
            'apikey': '1pzy3FOYTQk7171FElDfaCuGrJZ9r7sT'
          },
          success: res => {
            callback(res, obj);
          }
        })
      } else {
        callback(res, obj);
      }
    }
  })
}

/**
 * 小程序 - 判断是否需要再次登录 并 跳转页面
 */
const LoginAgainAndJumpPage = (callback) => {
  let userSession = wx.getStorageSync('userSession') || {}
  let _userInfo = wx.getStorageSync('userInfo') || {}
  /* 可能存在，多微信绑定同一个手机问题，所以这里暂时不再做鉴定，永远重新请求 */
  // if (userSession.sessionKey && _userInfo.nickName) {
  //   wx.checkSession({
  //     success: () => {
  //       callback()
  //     }, // session_key 未过期，并且在本生命周期一直有效
  //     fail: () => {
  //       // session_key 已经失效，需要重新执行登录流程
  //       miniGetInfo((res, obj) => { callback(res, obj); }) 
  //     }
  //   })
  // } else {
  //   // session_key 未存本地，则本地数据缺失
  //   miniGetInfo((res, obj) => { callback(res, obj); }) 
  // }
  miniGetInfo((res, obj) => { callback(res, obj); }) 
}


module.exports = {
  config: config,
  requestApi: requestApi,
  durationToTimeString: durationToTimeString,
  LoginAgainAndJumpPage: LoginAgainAndJumpPage,
}
/**
 * localStorage 中存放的 各种值
 * userSession - 调用 login 获取对应的 sessionKey openId等值
 * userInfo - 存放用户 头像、昵称等基本信息值
 * 
 * videoCacheCtrlBar
 * audioCacheCtrlBar
 */