// pages/learnSystem/courseContent/courseContent.js
const CourseApi = require('../../../apiService/CourseApi.js')
const util = require('../../../utils/util.js')

Page({
  /**
   * 页面的初始数据
   */
  data: {
    headerInfo: {
      id: '',
      sid: '',
      bgSrc: '../icons/home/default.jpg',
      title: '组织心理学',
      time: '2016-09-10至2017-01-10',
      status: '已发布',
      arrTab: ['3学分', '必修课', '第一学期'],
      isStart: true, // 是否为开始学习按钮 或者 选课按钮
      progress: '50%'
    },
    tabs: [{
      title: '课程简介',
      isShow: true,
      content: {
        text: '<p><b>组织心理学</b>是研究组织中人的心理与行为规律的一门科学，是心理学的一个重要分支，也是心理学在管理学方面的一个交叉应用学科。<b>组织心理学</b>通过探讨个体、群体以及结构对组织，<b>组织心理学</b>是研究组织中人的心理与行为规律的一门科学，是心理学的一个重要分支，也是心理学在管理学方面的一个交叉应用学科。<b>组织心理学</b>通过探讨个体、群体以及结构对组织。<p><p><b>组织心理学</b>是研究组织中人的心理与行为规律的一门科学，是心理学的一个重要分支，也是心理学在管理学方面的一个交叉应用学科。<b>组织心理学</b>通过探讨个体、群体以及结构对组织。</p>',
        teachers: [{
          src: '',
          name: '讲师姓名',
          edu: '学历',
          job: '职称',
          unit: '讲师所在单位'
        }, {
          src: '',
          name: '讲师姓名',
          edu: '学历',
          job: '职称',
          unit: '讲师所在单位'
        }]
      }
    }, {
      title: '课程内容',
      isShow: false,
      chapterList: {
        currentChapterId: '11', // 当前章节id
        course: [{
          title: '第一章：重要概念',
          isUp: true,
          chapters: [
            { id: '11', time: '28:18', name: '1.1 现值（PV）和终值（FV）' },
            { id: '12', time: '19:09', name: '1.2 净现值（NPV）及实际收益率' }
          ]
        }, {
          title: '第二章：证券估值',
          isUp: true,
          chapters: [
            { id: '21', time: '27:49', name: '2.1 债券和股票的现金流贴现估值方法' },
            { id: '22', time: '16:04', name: '2.2 债券评级及债券协议' },
            { id: '23', time: '', name: '公司金融第二周测验' },
            { id: '24', time: '', name: '公司金融第二周作业' }
          ]
        }, {
          title: '课程大作业',
          isUp: true,
          chapters: []
        }, {
          title: '课程资料',
          isUp: true,
          chapters: []
        }]
      }
    }, {
      title: '课程讨论',
      isShow: false,
    }, {
      title: '课程考核',
      isShow: false,
        richText: "<div class='h1'>一、最终成绩计算</div> <div class='p'>课程表现得分*30%+每章试题得分*30%+结业大作业得分*40%=该门课程总得分，满分100分，低于80分为不及格，需重修此门课程。84分以上方可申请学位。</div> <img class='b1' src='../icons/courseContent/b1.png' mode='aspectFill' /> <div class='h1'>二、具体细则</div> <div class='h2'>课程表现：总分100分（占科目总成绩的30%）</div> <div class='p'>1、每个视频观看完成度50分：以后台数据统计为准，全部看完视频满分50分，其它酌情给分。</div> <div class='em'>注：视频观看考核的是实际播放时长，不是进度条的显示状态，进度条满格并不一定表示观看完这个视频。以下方每日学习时长为准。</div> <div class='p'>2、课程反馈建设性问题及课程完成情况50分：反馈问题以教务老师统计为准，课程完成情况以后台数据为准，是否按时完成视频观看、测试、作业提交，满分50分，酌情给分。</div> <div class='h2'>每章试题：总分100分（占科目总成绩的30%）</div> <div class='p'>本课程所有试题的平均正确率*100分*占总成绩30%=此项得分。(比如正确度为80%，则此项得分：80%*100*30%=24分)</div> <div class='h2'>结业大作业：总分100分（占科目总成绩的40%）</div> <div class='p'>结业大作业满分为100分，以助教老师给分为准。</div>",
      // richText: `<dd data-reactid=".17ssbxqo7pw.0.1.1.0.0.1.0.0.1.1.1"><h4 data-reactid=".1bth85ikiwg.0.1.1.0.0.1.0.0.1.1.1.0" style="font - family: 'Helvetica Neue', Helvetica, Arial, sans-serif; color: rgb(63, 59, 58); margin-top: 10px; ">一、最终成绩计算</h4><p data-reactid=".1bth85ikiwg.0.1.1.0.0.1.0.0.1.1.1.1" style="color: rgb(63, 59, 58); font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif; font-size: 14px; line-height: 22.4px; ">课程表现得分*30%+每章试题得分*30%+结业大作业得分*40%=该门课程总得分，满分100分，低于80分为不及格，需重修此门课程。</p><div class="tac" data-reactid=".1bth85ikiwg.0.1.1.0.0.1.0.0.1.1.1.2" style="text-align: center; color: rgb(63, 59, 58); font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif; font-size: 14px; line-height: 22.4px; margin-bottom: 20px; "><img src="https://e-learning.ezijing.com/static/assets/img/course-check.png" data-reactid=".1bth85ikiwg.0.1.1.0.0.1.0.0.1.1.1.2.0"></div><h4 data-reactid=".1bth85ikiwg.0.1.1.0.0.1.0.0.1.1.1.3" style="font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif; color: rgb(63, 59, 58); margin-top: 10px;">二、具体细则</h4><h4 data-reactid=".1bth85ikiwg.0.1.1.0.0.1.0.0.1.1.1.4" style="font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif; color: rgb(63, 59, 58); margin-top: 10px;">课程表现：总分100分（占科目总成绩的30%）</h4><p data-reactid=".1bth85ikiwg.0.1.1.0.0.1.0.0.1.1.1.5" style="color: rgb(63, 59, 58); font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif; font-size: 14px; line-height: 22.4px;">1、每个视频观看完成度50分：以后台数据统计为准，全部看完视频满分50分，其它酌情给分。</p><p data-reactid=".1bth85ikiwg.0.1.1.0.0.1.0.0.1.1.1.6" style="color: rgb(63, 59, 58); font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif; font-size: 14px; line-height: 22.4px;"><span data-reactid=".1bth85ikiwg.0.1.1.0.0.1.0.0.1.1.1.6.0" style="color: rgb(176, 143, 57);">注：视频观看考核的是实际播放时长，不是进度条的显示状态，进度条满格并不一定表示观看完这个视频。以下方每日学习时长为准。</span></p><p data-reactid=".1bth85ikiwg.0.1.1.0.0.1.0.0.1.1.1.7" style="color: rgb(63, 59, 58); font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif; font-size: 14px; line-height: 22.4px;">2、课程讨论及反馈建设性问题50分：课程讨论以后台数据为准，反馈问题以教务老师问题统计为准，满分50分，酌情给分。</p><h4 data-reactid=".1bth85ikiwg.0.1.1.0.0.1.0.0.1.1.1.8" style="font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif; color: rgb(63, 59, 58); margin-top: 10px;">每章试题：总分100分（占科目总成绩的30%）</h4><p data-reactid=".1bth85ikiwg.0.1.1.0.0.1.0.0.1.1.1.9" style="color: rgb(63, 59, 58); font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif; font-size: 14px; line-height: 22.4px;">本课程所有试题的平均正确率*100分*占总成绩30%=此项得分。（比如正确度为80%，则此项得分：80%*100*30%=24分）。</p><h4 data-reactid=".1bth85ikiwg.0.1.1.0.0.1.0.0.1.1.1.a" style="font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif; color: rgb(63, 59, 58); margin-top: 10px;">结业大作业：总分100分（占科目总成绩的40%）</h4><p data-reactid=".1bth85ikiwg.0.1.1.0.0.1.0.0.1.1.1.b" style="color: rgb(63, 59, 58); font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif; font-size: 14px; line-height: 22.4px;">结业大作业满分为100分，以助教老师给分为准。</p></dd>`,
      assess: {
        score: '20',
        duration: '00:01:20',
        progress: '0/10',
        video: [{
          title: '第一章 市场营销原理导论',
          arr: [{
            name: '1.1 什么是市场营销什么是市场营销市场营销什么是市场营销什么是市场营销',
            time: '12:08',
            progress: '100%'
          }]
        }],
        homewrok: [{
          title: '第一章 市场营销原理导论',
          arr: [{
            name: '1.1 什么是市场营销什么是市场营销市场营销什么是市场营销什么是市场营销',
            score: 20
          }]
        }],
        essay: {
          status: '未提交',
          score: '暂无'
        }
      }
    }],
    isUseAccountLogin: true
  },
  cid: '',
  sid: '',
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    wx.showLoading({ title: '页面加载中...', mask: true })
    /* 判别 是否显示 账号登录 */
    this.setData({ 'isUseAccountLogin': true })
    
    this.cid = options.id
    this.sid = options.sid
    if (this.cid != '' && this.sid != '') {
      CourseApi.getCourseDetail(this.cid, this.sid, (json) => {
        this.setData({ 'headerInfo': json.headerInfo })
        this.setData({ 'tabs[0].content': json.tabs0Content })
        this.setData({ 'tabs[1].chapterList': json.tabs1ChapterList })
        json.tabs3richTest && this.setData({ 'tabs[3].richText': json.tabs3richTest.replace(/<img.*?(src=["|'].*?["|']).*?>/gi, '<img width="100%" $1>') })
        CourseApi.getCourseAssess(this.cid, this.sid, (json1) => {
          this.setData({ 'tabs[3].assess': json1 })
          wx.hideLoading()
        })
      })
    } else {
      wx.showLoading({ title: '页面数据异常，请联系管理员！', mask: true })
    }
  },
  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {},
  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {},
  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {},
  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {},
  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {
    // 显示顶部刷新图标
    if (this.cid != '' && this.sid != '') {
      wx.showNavigationBarLoading();
      wx.showLoading({ title: '更新中...', mask: true })
      CourseApi.getCourseDetail(this.cid, this.sid, (json) => {
        this.setData({ 'headerInfo': json.headerInfo })
        this.setData({ 'tabs[0].content': json.tabs0Content })
        this.setData({ 'tabs[1].chapterList': json.tabs1ChapterList })
        json.tabs3richTest && this.setData({ 'tabs[3].richText': json.tabs3richTest.replace(/<img.*?(src=["|'].*?["|']).*?>/gi, '<img width="100%" $1>') })
        CourseApi.getCourseAssess(this.cid, this.sid, (json1) => {
          this.setData({ 'tabs[3].assess': json1 })
          wx.hideLoading()
          // 隐藏导航栏加载框
          wx.hideNavigationBarLoading()
          // 停止下拉动作
          wx.stopPullDownRefresh()
        })
      })
    }
  },
  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {},
  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {},
  /**
   * 选课
   */
  wantThisCourse: function (e) {
    let cid = e.currentTarget.dataset.cid
    let sid = e.currentTarget.dataset.sid
    wx.showLoading({ title: '请求中...', mask: true })
    CourseApi.selectCourse(cid, sid, (json) => {
      this.setData({ 'headerInfo.isStart': true })
      wx.hideLoading()
      wx.showToast({ title: '选课成功', icon: 'none', duration: 1500 })
    })
  },
  /**
   * 退课 - 隐藏功能，点击 标题15次，进行退课
   */
  passCount: 0,
  noWantThisCourse: function (e) {
    if (this.passCount < 15) { this.passCount ++; return ; }
    let cid = e.currentTarget.dataset.cid
    let sid = e.currentTarget.dataset.sid
    wx.showLoading({ title: '请求中...', mask: true })
    CourseApi.outSelectCourse(cid, sid, (json) => {
      this.setData({ 'headerInfo.isStart': false })
      wx.hideLoading()
      wx.showToast({ title: '退课成功', icon: 'none', duration: 1500 })
      this.passCount = 0
    })
  },
  /**
   * 开始学习或继续学习 - 跳转到对应音视频播放页
   */
  startLearn: function (e) {
    let _data = e.target.dataset
    let cid = _data.cid, sid = _data.sid, vid = _data.vid,video_type = _data.type;
    wx.navigateTo({
      url: '/pages/videoPlayer/show' + '?cid=' + cid + '&sid=' + sid + '&vid=' + vid + '&type=' + video_type
    })
  },
  /**
   * 跳转到对应音视频播放页 
   */
  jumpToOtherVA: function (e) {
    /* 如果未选课，不能查看课程内容 */
    if (!this.data.headerInfo.isStart) { wx.showToast({ title: '先选课，才能看', icon: 'none', duration: 1500 }); return ; }
    let _data = e.target.dataset
    let cid = _data.cid, sid = _data.sid, vid = _data.vid,video_type = _data.type;
    if (!_data.hasva) { 
      /* 如果存在 - 课后习题类型， type:3、work_type:1 */
      let i1 = _data.index, i2 = _data.index1
      let _course = this.data.tabs[1].chapterList.course[i1]
      if (_course && _course.chapters[i2] && _course.chapters[i2].homework) {
        let _hw = _course.chapters[i2].homework
        wx.setStorageSync('_homework', _hw)
        wx.navigateTo({
          url: '/pages/learnSystem/courseContent/examDetail/examDetail'
        })
        return ;
      }
      wx.showToast({ title: '请在PC上使用该功能', icon: 'none' }); return ; 
    }
    
    wx.navigateTo({
      url: '/pages/videoPlayer/show' + '?cid=' + cid + '&sid=' + sid + '&vid=' + vid + '&type=' + video_type
    })
  },
  /**
   * 切换 - tab
   */
  tabSelect: function (e) {
    let index = e.currentTarget.dataset.index
    if (index == 2) { 
      wx.navigateTo({
        url: '/pages/learnSystem/courseContent/courseDiscuss/courseDiscuss?cid=' + e.currentTarget.dataset.cid + '&sid=' + e.currentTarget.dataset.sid
      })
      return
    }
    let json = this.data.tabs
    for(let i = 0; i < json.length; i++) {
      json[i].isShow = false
    }
    json[index].isShow = true
    this.setData({ 'tabs': json })
  },
  /**
   * 课程内容 - 列表展开或者跳转
   */
  clickJumpOrStatus: function (e) {
    let data = e.currentTarget.dataset;
    let flag = data.status;
    if (flag) {
      let index = data.index;
      let json = this.data.tabs;
      let temp = json[1].chapterList.course[index];
      temp.isUp = !temp.isUp;
      this.setData({ 'tabs': json });
    } else {
      /* 跳转 */
      wx.showToast({ title: '请上PC使用该功能', icon: 'none' })
    }
  },

  // 发送formid
  formSubmit: function(e) {
    util.sendformid(e.detail.formId);
    console.log('form发生了submit事件，携带数据为：', e.detail.formId)
  }
})