// pages/learnSystem/myScore/myScore.js
const ScoreApi = require('../../../apiService/ScoreApi.js')

Page({
  /**
   * 页面的初始数据
   */
  data: {
    score: {
      total: 0,
      myTotal: 0,
      myTotalStr: '0%',
      must: 0,
      myMust: 0,
      myMustStr: '0%',
      unmust: 0,
      myUnmust: 0,
      myUnmustStr: '0%',
      lists: []
    }
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    wx.showLoading({ title: '页面加载中...', mask: true })
    ScoreApi.getMyScore((json) => {
      this.setData({ 'score': json });
      wx.hideLoading()
    })
  },
  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {},
  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {},
  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {},
  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {},
  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {
    // 显示顶部刷新图标
    wx.showNavigationBarLoading()
    wx.showLoading({ title: '更新中...', mask: true })
    ScoreApi.getMyScore((json) => {
      this.setData({ 'score': json })
      wx.hideLoading()
      // 隐藏导航栏加载框
      wx.hideNavigationBarLoading()
      // 停止下拉动作
      wx.stopPullDownRefresh()
    })
  },
  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {},
  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {}
})