// pages/videoPlayer/AllBugPages/page1/bugPage1.js
const util = require('../../../../utils/util.js')

Page({
  data: {
    isVideoShow: false,
    currentTime: 0,
    totalTime: 0,
    video: {
      src: ''
    }
  },
  _audio: null,
  _video: null,
  playVideo: false,
  playAudio: false,
  onHide: function () { this.videoPause() },
  onReady: function () {
    this.setData({ 'isVideoShow': true })
    this.setData({ 'video.src': 'https://cd15-c120-1.play.bokecc.com/flvs/C67C24BF493FE39E/2016-03-29/CD319C8C0265B11A9C33DC5901307461-20.m3u8?t=1536297247&key=2467F8448E028A1614E354B75A457951' })
    setTimeout(() => {
      this._video = wx.createVideoContext('video-play')
    }, 1000)
    this._audio = wx.createAudioContext('audio-play')
  },
  audioPlay: function () { this._audio.play(); this.playAudio = true; this.playVideo = false; },
  videoPlay: function () { this._video.play(); this.playAudio = false; this.playVideo = true; },
  audioPause: function () { this._audio.pause(); this.playAudio = false; },
  videoPause: function () { this._video.pause(); this.playVideo = false; },
  videoShowOrHide: function () { this.setData({ 'isVideoShow': !this.data.isVideoShow }) },
  changeVideo: function () { this.setData({ 'video.src': 'https://pd4t7ae3m.bkt.clouddn.com/test.mp4' }); },
  timeUpdate: function (e) {
    let _data = this.data, _status = _data.status, _detail = e.detail, _obj = {}
    console.log('视频时间变化', parseInt(_detail.currentTime))
    _obj.currentTime = parseInt(_detail.currentTime)
    _obj.totalTime = parseInt(_detail.duration)
    this.setData({ 'ctrlBar.progress': _obj.currentTime / _obj.totalTime * 100 + '%' });
    this.setData({ 'currentTime': util.durationToTimeString(_obj.currentTime) });
    this.setData({ 'totalTime': util.durationToTimeString(_obj.totalTime) })
  },
  /**
   * 第一种情况：
   * 在播放音视频时，打开预览大图，会暂停播放音视频。
   */
  viewImage1: function () {
    let _ = this
    wx.previewImage({
      urls: [
        'https://pd4t7ae3m.bkt.clouddn.com/imgs-test1.jpg',
        'https://pd4t7ae3m.bkt.clouddn.com/imgs-test2.jpg',
        'https://pd4t7ae3m.bkt.clouddn.com/imgs-test3.jpg'
      ],
      current: 0,
      success: () => {
        _.playAudio && _._audio.play()
        _.playVideo && _._video.play()
      }
    })
    _.playAudio && _._audio.play()
    _.playVideo && _._video.play()
  },
  /**
   * 第二种情况：
   * 音视频播放过程中，在打开预览图片前，手动调用方法暂停播放，但是关闭预览图片后，发现问题。
   * android 视频播放未暂停，ios 正常
   */
  viewImage2: function () {
    let _ = this
    this.audioPause()
    this.videoPause()

    wx.previewImage({
      urls: [
        'https://pd4t7ae3m.bkt.clouddn.com/imgs-test1.jpg',
        'https://pd4t7ae3m.bkt.clouddn.com/imgs-test2.jpg',
        'https://pd4t7ae3m.bkt.clouddn.com/imgs-test3.jpg'
      ],
      current: 0,
      success: () => {}
    })
  }
})