/**
 * 所有相关配置项
 */
const url_test = {
   // URL_PATH: 'http://dev.ezijing.com:3000/api', // 本地开发域名
  // outSiteLink: 'https://applets.ezijing.com', // 本地测试外链
  // URL_PATH: 'https://api2.ezijing.com', // 测试域名
  // outSiteLink: 'https://kelley2.ezijing.com', // 测试外链
  URL_PATH: 'https://api.ezijing.com/tenant', // 正式域名 - 由于项目变动域名
  URL_PATH1: 'https://lms-api2.ezijing.com', // 正式域名 - 由于项目变动域名
  URL_PATH2: 'https://sso2.ezijing.com', // 正式域名 - 由于项目变动域名
  outSiteLink: 'https://e-learning.ezijing.com', // 正式外链
  tenant: 'zjkelley',
  version: '3.1.3'
};
const url_online = {
  URL_PATH: 'https://api.ezijing.com/tenant', // 正式域名 - 由于项目变动域名
  URL_PATH1: 'https://lms-api.ezijing.com', // 正式域名 - 由于项目变动域名
  URL_PATH2: 'https://sso.ezijing.com', // 正式域名 - 由于项目变动域名
  outSiteLink: 'https://e-learning.ezijing.com', // 正式外链
  tenant: 'zjkelley',
  version: '3.1.3'
}
let config = url_online;
/* 请求接口统一 重定义 */
const requestApi = (obj) => {
  let _token = wx.getStorageSync('userSession').sessionKey;
  if (!_token) {
    wx.reLaunch({ url: '/pages/index/index' })
    return ;
  }

  wx.request({
    url: obj.url,
    data: obj.data || '', // 不必填
    header: {
      'token': _token,
      'tenant': config.tenant,
      'content-type': 'application/x-www-form-urlencoded',
      'apikey': 'pP5ECUqRDLDzuh4qRuJro0L1LPgjLP0N',
      'version': config.version
    },
    method: obj.method || 'GET', // 不必填，默认 GET
    dataType: 'json',
    success: function (res) {
      if (res.statusCode === 200) { 
        // if (res.data.status === 200) {
        //   obj.callback(res.data) // 直接把数据处理好，然后直接 返回 
        // } else {
        //   wx.showToast({ title: JSON.stringify(res.data), icon: 'none' }) // 自己后台封装返回
        // }
        obj.callback(res)
      } else if (res.statusCode === 403 || res.statusCode === 401) {
        /* 未授权登录，跳转首页 */
        wx.reLaunch({
          url: '/pages/index/index'
        })
      } else {
        wx.showToast({ title: res.errMsg, icon: 'none' }) // 微信封装返回
      }
    },
    fail: function (res) {
      wx.showToast({ title: JSON.stringify(res), icon: 'none' })
    }
  })
};
/* 工具方法 - 播放时间 转化 h:m:s */
const durationToTimeString = (duration) => {
  let h = Math.floor(duration / 3600);
  let m = Math.floor((duration - h * 3600) / 60);
  let s = (duration - h * 3600 - m * 60) % 60;
  function tenify(a) {
    return a >= 10 ? a : '0' + a;
  }
  let to = { h: tenify(h), m: tenify(m), s: tenify(s) }
  let format = 'h:m:s';
  return format.replace(/h|m|s/g, k => to[k]).replace(/^00\:/, '');
};

/**
 * 小程序 - 获取用户信息
 */
const miniGetInfo = (callback) => {
  // 获取用户凭证code - 使用 login API获取
  wx.login({
    success: res => {
      let obj = {}
      obj.code = res.code
      // 获取用户授权设置 - 使用 getSetting API获取
      wx.getSetting({
        success: res1 => {
          if (res1.authSetting['scope.userInfo']) {
            // 获取用户信息 - 使用 getUserInfo API获取
            wx.getUserInfo({
              withCredentials: true,
              success: res2 => {
                obj.encryptedData = res2.encryptedData
                obj.iv = res2.iv
                obj.userInfo = res2.userInfo
                /**
                 * 这里 调用后台接口 loginApi，传参如下
                 * obj.code
                 * obj.encryptedData
                 * obj.iv
                 * obj.userInfo
                 */
                loginApi(obj, (res, obj) => { callback(res, obj); })
              },
              fail: res2 => { wx.hideLoading(); wx.showToast({ title: '用户信息获取失败，请重试', icon: 'none' }); }
            })
          } else {
            wx.hideLoading(); wx.showToast({ title: '请先点击登录', icon: 'none' });
          }
        },
        fail: res1 => { wx.hideLoading(); wx.showToast({ title: '用户授权设置获取失败，请重试', icon: 'none' }); }
      })
    },
    fail: res => { wx.hideLoading(); wx.showToast({ title: '用户凭证code获取失败，请重试', icon: 'none' }); }
  })
};

/**
 * 登录api - 获取 openId 、userName等内容
 */
const loginApi = (obj, callback) => {
  /* 特殊绑定 接口 跟 其他登录 接口不一致，这个主要用来 做 扫码登录使用 */
  // sid 6489388550075711488
  // class_id 6488300987269251072
  // 6489392145194024960 公司金融
  // 6489392226584494080 家族财富传承
  // 6489392240857710592 金融科技：全球与本土视角
  let scene = wx.getStorageSync('scene')
  let wenti_id = ''
  let cids = ''
  let semester_id = '6489388550075711488'
  let class_id = '6488300987269251072'
  if (scene) {
    wenti_id = scene.split('&')[0]
    cids = scene.split('&')[1] + ','
    cids = cids.replace(/1,/gi, '6489392145194024960,').replace(/2,/gi, '6489392226584494080,').replace(/3,/gi, '6489392240857710592,')
    cids = cids.substr(0, cids.length - 1)
  } else {
    class_id = ''
    semester_id = ''
  }
  wx.request({
<<<<<<< HEAD
    url: config.URL_PATH + '/user/authorization', 
    data: { code: obj.code, encrypted_data: obj.encryptedData, iv: obj.iv, course_ids: cids, semester_id: semester_id, class_id: class_id, survey_id: wenti_id, idt: config.tenant }, method: 'POST', header: {
      tenant: config.tenant
=======
    url: config.URL_PATH1 + '/user/check-unionid', 
    data: { code: obj.code, encrypted_data: obj.encryptedData, iv: obj.iv }, method: 'POST', header: {
      tenant: config.tenant,
      'version': config.version,
      apikey: 'pP5ECUqRDLDzuh4qRuJro0L1LPgjLP0N'
>>>>>>> master
    }, 
    success: res => {
      if (res.statusCode == 200) {
        wx.setStorageSync('union_id', res.data.union_id);
        wx.setStorageSync('openId', res.data.open_id);
        wx.request({
          url: config.URL_PATH2 + '/user_center/wechat_login', 
          data: { wechat_unionid: res.data.union_id, service: 'applet.ezijing.com' }, method: 'POST', header: {
            'tenant': config.tenant,
            'content-type': 'application/x-www-form-urlencoded',
            'version': config.version,
            'apikey': 'pP5ECUqRDLDzuh4qRuJro0L1LPgjLP0N'
          },
          success: res1 => {
            if (res1.statusCode == 200) {
              let _token = res1.data.ticket;
              if (!_token) {
                wx.reLaunch({ url: '/pages/index/index' })
                return ;
              }
              wx.setStorageSync('userSession', { 'sessionKey': _token });

              /* 获取用户信息 */
              wx.request({
                url: config.URL_PATH1 + '/user/check-access',
                data: {}, method: 'GET', header: {
                  token: _token,
                  tenant: config.tenant,
                  'version': config.version,
                  'apikey': 'pP5ECUqRDLDzuh4qRuJro0L1LPgjLP0N',
                  unionid: res.data.union_id
                },
                success: res2 => {
                  if (res2.statusCode != 200) { wx.showToast({ title: res2.data.message||'获取用户信息失败', icon: 'none' }); return; }

                  wx.setStorageSync("sid", res2.data.id);
                  wx.setStorageSync("uid", res1.data.uid);
                  callback(res1, obj);
                }
              })
            }else{
              callback(res1, obj);
            } 

          }
        })
      } else {
        callback(res, obj);
      }
    }
  })
};

/**
 * 小程序 - 判断是否需要再次登录 并 跳转页面
 */
const LoginAgainAndJumpPage = (callback) => {
  let userSession = wx.getStorageSync('userSession') || {}
  let _userInfo = wx.getStorageSync('userInfo') || {}
  /* 可能存在，多微信绑定同一个手机问题，所以这里暂时不再做鉴定，永远重新请求 */
  // if (userSession.sessionKey && _userInfo.nickName) {
  //   wx.checkSession({
  //     success: () => {
  //       callback()
  //     }, // session_key 未过期，并且在本生命周期一直有效
  //     fail: () => {
  //       // session_key 已经失效，需要重新执行登录流程
  //       miniGetInfo((res, obj) => { callback(res, obj); }) 
  //     }
  //   })
  // } else {
  //   // session_key 未存本地，则本地数据缺失
  //   miniGetInfo((res, obj) => { callback(res, obj); }) 
  // }
  miniGetInfo((res, obj) => { callback(res, obj); }) 
};

// 上报formid
const sendformid = (formId) => {
    let _token = wx.getStorageSync('userSession').sessionKey;
    if (!_token) {
      wx.reLaunch({ url: '/pages/index/index' })
      return ;
    }
    wx.request({
      url: config.URL_PATH1 + '/v2/education/formid', 
      data:{
        openid: wx.getStorageSync('openId'),
        formid: formId
      },
      header:{
        'token': _token,
        'tenant': config.tenant,
        'content-type': 'application/x-www-form-urlencoded',
        'apikey': 'pP5ECUqRDLDzuh4qRuJro0L1LPgjLP0N',
        'version': config.version
      },
      method:'POST'
    })
}

/**
 * localStorage 中存放的 各种值
 * userSession - 调用 login 获取对应的 sessionKey openId等值
 * userInfo - 存放用户 头像、昵称等基本信息值
 * 
 * videoCacheCtrlBar
 * audioCacheCtrlBar
 */

module.exports = {
  'config': config,
  requestApi: requestApi,
  durationToTimeString: durationToTimeString,
  sendformid: sendformid,
  LoginAgainAndJumpPage: LoginAgainAndJumpPage
};
