// pages/learnSystem/courseSquare/courseSquare.js
const CourseApi = require('../../../apiService/CourseApi.js')

Page({
  /**
   * 页面的初始数据
   */
  data: {
    find: [{
      name: '学期',
      isShow: false,
      selectIndex: 0,
      key: 'semester_id',
      arrItem: [ // 从后台请求
        { val: '-1', name: '全部' },
        { val: '', name: '第一学期' },
        { val: '', name: '第二学期' },
        { val: '', name: '第三学期' },
        { val: '', name: '第四学期' }
      ]
    }, {
      name: '课程类型',
      isShow: false,
      selectIndex: 0,
      key: 'course_type',
      arrItem: [
        { val: '-1', name: '全部' },
        { val: '1', name: '必修课' },
        { val: '2', name: '选修课' }
        // { val: '3', name: '重修课' }
      ]
    }, {
      name: '选修状态',
      isShow: false,
      selectIndex: 0,
      key: 'select_status',
      arrItem: [
        { val: '-1', name: '全部' },
        { val: '0', name: '未选修' },
        { val: '1', name: '已选修' }
      ]
    }],
    homeList: [
    //   {
    //   id: '',
    //   src: '../icons/home/default.jpg',
    //   title: '这里是一条长的标题不要超过25个汉字标题不要超过25个汉字',
    //   arrTab: ['3学分', '必修课', '第一学期'],
    //   status: '已发布',
    //   time: '2016-09-10至2017-01-10',
    //   myStatus: '已选修',
    //   progress: '50%'
    // }
    ]
  },
  param: {},
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) { 
    wx.showLoading({ title: '页面加载中...', mask: true })
    CourseApi.getlearnFindList((_) => {
      this.setData({ 'find[0].arrItem': _ })
      CourseApi.getCourseList(false, this.param, (json) => {
        this.setData({ 'homeList': json })
        wx.hideLoading()
      })
    })
  },
  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {},
  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {
  },
  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () { },
  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () { },
  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () { },
  /**
   * 跳转 - 课程详情页
   */
  goCourseContent: function (e) {
    let id = e.currentTarget.dataset.id
    let sid = e.currentTarget.dataset.sid
    wx.navigateTo({
      url: '/pages/learnSystem/courseContent/courseContent?id=' + id + '&sid=' + sid
    })
  },
  /**
   * 分类选择 - 显示
   */
  selFindShow: function (e) {
    let index = e.currentTarget.dataset.index
    let json = this.data.find
    /* 本来就是打开状态，再点击关闭 */
    if (json[index].isShow) {
      json[index].isShow = false
    } else {
      for (let i = 0; i < json.length; i++) {
        json[i].isShow = false
      }
      json[index].isShow = true
    }
    this.setData({ 'find': json })
  },
  /**
   * 分类选择 - 隐藏
   */
  selFindHide: function (e) {
    let json = this.data.find
    for (let i = 0; i < json.length; i++) {
      json[i].isShow = false
    }
    this.setData({ 'find': json })
  },
  /**
   * 分类选择 - 选中某一项
   */
  selFindSelect: function (e) {
    let _data = e.currentTarget.dataset, index = _data.index
    let json = this.data.find
    for (let i = 0; i < json.length; i++) {
      if (json[i].isShow) {
        json[i].selectIndex = index
        json[i].isShow = false
        if (_data.val == '-1') {
          delete this.param[_data.key]
        } else {
          this.param[_data.key] = _data.val
        }
        break
      }
    }
    this.setData({ 'find': json })
    /* 调用接口 */
    wx.showLoading({ title: '加载中...', mask: true })
    CourseApi.getCourseList(false, this.param, (json) => {
      this.setData({ 'homeList': json })
      wx.hideLoading()
    })
  },
  /**
   * 上拉加载更多
   */
  loadmore: function () {
    wx.showLoading({ title: '加载中...', mask: true })
    CourseApi.getCourseList(false, this.param, (json) => {
      this.setData({ 'homeList': json })
      wx.hideLoading()
      wx.showToast({ title: '没有更多了', icon: 'none' })
    })
  },
  /**
   * 上拉刷新
   */
  updatenew: function () {
    wx.showLoading({ title: '更新中...', mask: true })
    CourseApi.getCourseList(false, this.param, (json) => {
      this.setData({ 'homeList': json })
      wx.hideLoading()
      wx.showToast({ title: '已更新', icon: 'none' })
    })
  }
})