// pages/learnSystem/discussDetail/discussDetail.js
const DiscussApi = require('../../../apiService/DiscussApi.js')

Page({
  /**
   * 页面的初始数据
   */
  data: {
    discussQues: {
      // qid: '', user: { url: './icons/default.jpg', name: '用户名000', time: '2018-2-12 15:28:47' },
      // title: '这是一个一句话问题这是一个一句话问题这是一个一句话问题标题这是一个一句话问题',
      // text: '<p>王家有三兄弟甲、乙、丙，丙幼年时送给胡某作养子，丙结婚时，胡某为其盖了新房，后因失火致使该房屋被烧毁。丙的生父母就将自己<p>',
      // askCnt: 20, TouCnt: 100, likeCnt: 100, comCnt: 100, mine: true, isShowComment: false, has_tag: false, tag_id: null,
      // comments: [
      //   { cid: '', user: { url: './icons/default.jpg', name: '用户名000', time: '2018-2-12 15:28:47' }, text: '在线学习课程', mine: true }, 
      //   { cid: '', user: { url: './icons/default.jpg', name: '用户名000', time: '2018-2-12 15:28:47' }, text: '在线学习课程', mine: false }
      // ]
    },
    answersList: [
    // {
      // aid: '', user: { url: './icons/default.jpg', name: '用户名000', time: '2018-2-12 15:28:47' },
      // text: '<p>王家有三兄弟甲、乙、丙，丙幼年时送给胡某作养子，丙结婚时，胡某为其盖了新房，后因失火致使该房屋被烧毁。丙的生父母就将自己<p>',
      // likeCnt: 100, comCnt: 100, mine: true, isShowComment: false, has_tag: false, tag_id: null,
      // comments: [
        // { cid: '', user: { url: './icons/default.jpg', name: '用户名000', time: '2018-2-12 15:28:47' }, text: '在线学习课程', mine: true }
      // ]
    // }
    ],
    /* 存储状态值 的对象, 记录上次用户操作 */
    disQus: {
      isShowComment: false
    },
    answers: [  // 数组 跟 上面 answerList数组对应, 存储某些状态值，目前存储讨论打开关闭状态
      { aid: '', isShowComment: false }
    ],
    inputStatus: {
      canFocus: false,
      placeholder: '回答问题 ...',
      input: ''
    }
  },
  qid: '6447416971762860032',
  /* 回复内容状态 */
  call: {},
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    this.qid = options.qid
    this.sid = options.sid
    this.call = { questionId: this.qid, semester_id: '', contents: '', question_id: this.qid, answer: true }
    wx.showLoading({ title: '页面加载中...', mask: true })
    DiscussApi.getDiscussDetail(this.qid, (json) => {
      this.setData({ 'discussQues': json.ques })
      this.call.semester_id = this.data.discussQues.sid
      this.setData({ 'disQus.isShowComment': json.ques.isShowComment })
      let answers = []
      for (let i = 0; i < json.answer.length; i++) {
        answers.push({
          aid: json.answer[i].aid,
          isShowComment: json.answer[i].isShowComment
        })
      }
      this.setData({ 'answersList': json.answer })
      this.setData({ 'answers': answers })
      wx.hideLoading()
    })
  },
  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () { },
  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () { },
  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () { },
  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () { },
  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () { },
  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () { },
  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () { },
  /**
   * 打开或关闭 讨论
   */
  openOrcloseDis: function (e) {
    let key = e.currentTarget.dataset.key
    if (key == 'disQus') {
      this.setData({ 'disQus.isShowComment': !this.data.disQus.isShowComment })
    } else {
      let index = e.currentTarget.dataset.index
      let cname = 'answers[' + index + '].isShowComment'
      this.setData({ [cname]: !this.data.answers[index].isShowComment })
    }
  },
  /**
   * 删除评论
   */
  deleteComment: function (e) {
    let cid = e.currentTarget.dataset.cid
    wx.showModal({
      title: '提示', content: '确定删除该条评论？',
      success: (res) => {
        if (res.confirm) {
          wx.showLoading({ title: '操作中...', mask: true })
          DiscussApi.deleteComment(cid, (json) => {
            this.updateList()
          })
        }
      }
    })
  },
  /**
   * 删除回答
   */
  deleteAnswer: function (e) {
    let aid = e.currentTarget.dataset.aid
    wx.showModal({
      title: '提示', content: '确定删除该条回答？',
      success: (res) => {
        if (res.confirm) {
          wx.showLoading({ title: '操作中...', mask: true })
          DiscussApi.deleteAnswer(aid, (json) => {
            this.updateList()
          })
        }
      }
    })
  },
  /**
   * 点击回复 调起输入框
   */
  callbackComment: function (e) {
    /* 如果，输入框中，本身已经存在输入内容，那么再点击其他回复时，不给提示，直接清空 */
    this.setData({ 'inputStatus.input': '' }) // 这里如果想判断，不能使用 inputStatus.input这个 在blur时存储
    
    let _data = e.currentTarget.dataset
    let qid = _data.qid, quesid = _data.quesid, ansid = _data.ansid, to = _data.to, sid = _data.sid
    let json = {}
    if (qid) { json['questionId'] = qid }
    if (to) { json['to'] = to }
    if (quesid) { json['question_id'] = quesid }
    if (ansid) { json['answer_id'] = ansid }
    if (sid) { json['semester_id'] = sid }
    this.call = json
    if (to) { 
      this.setData({ 'inputStatus.placeholder': '回复' + to + '：' }) 
    } else { 
      this.setData({ 'inputStatus.placeholder': '回复：' }) 
    }
    this.setData({ 'inputStatus.canFocus': true })
  },
  /**
   * 取消 聚焦状态
   */
  blurInput: function (e) {
    this.setData({ 'inputStatus.canFocus': false })
    if (e && e.detail && e.detail.value) {
      // 输入框中存在内容则不做处理 - 这里不能做任何处理，否则会产生 输入框中内容遗留问题
    } else {
      this.setData({ 'inputStatus.placeholder': '回答问题 ...' })
      this.setData({ 'inputStatus.input': '' })
      // 回答问题 方式
      this.call = {
        questionId: this.data.discussQues.qid,
        semester_id: this.data.discussQues.sid,
        contents: '',
        question_id: this.data.discussQues.qid,
        answer: true
      }
    }
  },
  /**
   * 点击 键盘发送按钮时
   */
  publishContent: function (e) {
    let val = e.detail.value
    if (this.call.to) {
      this.call['comments'] = '回复' + this.call.to + '：' + val
    } else {
      this.call['comments'] = val
    }
    if (this.call.answer) { // 回答问题
      wx.showLoading({ title: '操作中...', mask: true })
      this.call['contents'] = this.call['comments']
      DiscussApi.answerQues(this.call, (json) => {
        this.updateList()
        wx.hideLoading()
      })
    } else { // 回复评论
      wx.showLoading({ title: '操作中...', mask: true })
      DiscussApi.callbackComment(this.call, (json) => {
        this.updateList()
        wx.hideLoading()
      })
    }
    this.blurInput()
  },
  /**
   * 点赞 或 取消点赞 操作
   */
  btnlike: function (e) {
    let _data = e.currentTarget.dataset
    let quesid = _data.quesid, ansid = _data.ansid, tagid = _data.tagid, sid = _data.sid
    if (tagid) { // 取消 点赞操作
      wx.showLoading({ title: '操作中...', mask: true })
      DiscussApi.unlike(tagid, (json) => {
        this.updateList()
        wx.hideLoading()
      })
    } else { // 点赞操作
      let param = {}
      if (quesid) { param['question_id'] = quesid }
      if (ansid) { param['answer_id'] = ansid }
      if (sid) { param['semester_id'] = sid }
      wx.showLoading({ title: '操作中...', mask: true })
      DiscussApi.like(param, (json) => {
        this.updateList()
        wx.hideLoading()
      })
    }
  },
  /**
   * 删除问题
   */
  deleteDiscuss: function () {
    wx.showModal({
      title: '提示', content: '确定删除提问吗？',
      success: (res) => {
        if (res.confirm) {
          wx.showLoading({ title: '操作中...', mask: true })
          DiscussApi.deleteDiscuss(this.qid, (json) => {
            wx.navigateBack({ delta: 1 })
          })
        }
      }
    })
  },
  /* 刷新页面 全部状态 - 目前没有分页可以这么操作，如果存在分页，可能要重写 */
  updateList: function () {
    DiscussApi.getDiscussDetail(this.qid, (json) => {
      this.setData({ 'discussQues': json.ques })
      let _answers = this.data.answers
      for (let i = 0; i < _answers.length; i++) {
        for (let j = 0; j < json.answer.length; j++) {
          if (_answers[i].aid == json.answer[j].aid) {
            json.answer[j].isShowComment = _answers[i].isShowComment
            break
          }
        }
      }
      let answers = []
      for (let i = 0; i < json.answer.length; i++) {
        answers.push({
          aid: json.answer[i].aid,
          isShowComment: json.answer[i].isShowComment
        })
      }
      this.setData({ 'answersList': json.answer })
      this.setData({ 'answers': answers })
      wx.hideLoading()
    })
  }
})