/**
 * 创建一个audio对象
 * @param {[string]} src [audio组件对应音频源]
 * @param {[object]} _that [当前组件所在页面对应this]
 */
var Audio = function (src, _that) {
  if (!(this instanceof Audio)) {
    return new Audio(src, _that);
  } else {
    this._audio = this.init(src, _that);
    this.currentTime = 0; // 当前时间
    this.totalTime = 0; // 总时间
    this.rateIndex = 2; // 取值为 RATE中的 下标 0，1，2，3，4
  }
}
/**
 * audio对象创建后，提供的方法
 * init - 初始化方法
 * play - 视频播放
 * pause - 视频暂停
 * stop - 视频停止
 * seek - 视频跳到某个位置再播放
 * rate - 视频播放速率调整
 * 
 */
Audio.prototype = {
  constructor: Audio,
  RATE: ['0.5', '0.8', '1.0', '1.25', '1.5'],
  init: function (src, _that) {
    let _auCtx = wx.createInnerAudioContext();
    _auCtx.autoplay = false;
    _auCtx.src = src;
    /* 使用绑定事件，代替wxml中的事件绑定 */
    _auCtx.onTimeUpdate(() => { let e = { detail: { currentTime: _auCtx.currentTime, duration: _auCtx.duration } }; _that.timeUpdate(e) })
    _auCtx.onPlay(() => { _that.beginPlayVA() })
    _auCtx.onError((e) => { _that.playError(e) })
    _auCtx.onEnded(() => { _that.playEnded })
    return _auCtx;
  },
  play: function () {
    this._audio.play();
  },
  pause: function () {
    this._audio.pause();
  },
  stop: function () {
    this._audio.stop();
  },
  seek: function (time) {
    this._audio.seek(time);
  },
  fastSlow15: function (timeStr) {
    this._audio.seek(this.currentTime + parseInt(timeStr));
  },
  rate: function () {
    this.rateIndex++;
    if (this.rateIndex > 4) this.rateIndex = 0;
    this._audio.playbackRate(parseFloat(this.RATE[this.rateIndex]));
  }
  

}
module.exports = {
  Audio: Audio
}
