/**
 * 创建一个video对象
 * @param {[string]} selectorId [video组件id对应选择器字符串]
 */
var Video = function (selectorId) {
  if (!(this instanceof Video)) {
    return new Video(selectorId);
  } else {
    this._video = this.init(selectorId);
    this.currentTime = 0; // 当前时间
    this.totalTime = 0; // 总时间
    this.rateIndex = 2; // 取值为 RATE中的 下标 0，1，2，3，4
  }
}
/**
 * video对象创建后，提供的方法
 * init - 初始化方法
 * play - 视频播放
 * pause - 视频暂停
 * stop - 视频停止
 * seek - 视频跳到某个位置再播放
 * rate - 视频播放速率调整
 * 
 */
Video.prototype = {
  constructor: Video,
  RATE: ['0.5', '0.8', '1.0', '1.25', '1.5'],
  init: function (selectorId) {
    return wx.createVideoContext(selectorId);
  },
  play: function () {
    this._video.play();
  },
  pause: function () {
    this._video.pause();
  },
  stop: function () {
    this._video.stop();
  },
  seek: function (time) {
    this._video.seek(time);
  },
  fastSlow15: function (timeStr) {
    this._video.seek(this.currentTime + parseInt(timeStr));
  },
  rate: function () {
    this.rateIndex ++;
    if (this.rateIndex > 4) this.rateIndex = 0;
    this._video.playbackRate(parseFloat(this.RATE[this.rateIndex]));
  }
}
module.exports = {
  Video: Video
}
