const util = require('../utils/util.js')
/**
 * 本API中全部用于 讨论 相关接口
 */

/* 获取讨论题目列表，“我提出的问题”和“我参与的问题”信息 */
/**
 * dataJson.limit - 获取数量
 * dataJson.offset - 偏移量
 */
const getDiscussList = (path, dataJson, callback) => {
  util.requestApi({
    url: util.config.URL_PATH + '/ep/v2/qa/questions' + path,
    data: dataJson,
    callback: function (res) {
      let _data = res.data
      let json = _data.map(function (_, i) {
        return {
          id: _.id,
          sid: _.semester_id,
          user: {
            url: _.questioner.avatar || '../icons/my/default.jpg',
            name: _.questioner.nickname,
            time: _.created_time
          },
          title: _.title,
          text: _.contents,
          askCnt: _.answer_count,
          TouCnt: _.tag_total_count,
          courseName: '在线学习课程',
          comments: _.comments,
          mine: _.mine
        }
      })
      callback(json)
    }
  })
}
/* 获取讨论题目列表，“课程的问题”信息 */
/**
 * dataJson.limit - 获取数量
 * dataJson.offset - 偏移量
 * dataJson.sort - 排序类型
 */
const getCourseDiscussList = (cid, sid, dataJson, callback) => {
  util.requestApi({
    url: util.config.URL_PATH + '/ep/v2/qa/questions/course/' + sid + '/' + cid,
    data: dataJson,
    callback: function (res) {
      let _data = res.data
      let json = _data.map(function (_, i) {
        return {
          id: _.id,
          sid: _.semester_id,
          user: {
            url: _.questioner.avatar || './icons/default.jpg',
            name: _.questioner.nickname,
            time: _.created_time
          },
          title: _.title,
          text: _.contents,
          askCnt: _.answer_count,
          TouCnt: _.tag_total_count,
          courseName: '在线学习课程',
          comments: _.comments,
          mine: _.mine
        }
      })
      callback(json)
    }
  })
}
/* 获取问题详情 */
const getDiscussDetail = (qid, callback) => {
  util.requestApi({
    url: util.config.URL_PATH + '/ep/v2/qa/questions/' + qid,
    callback: function (res) {
      let _data = res.data
      let json = {
        ques: {
          qid: _data.id,
          sid: _data.semester_id,
          user: {
            url: _data.questioner.avatar || './icons/default.jpg',
            name: _data.questioner.nickname,
            time: _data.created_time
          },
          title: _data.title,
          text: _data.contents,
          askCnt: _data.answer_count || 0,
          TouCnt: _data.tag_total_count || 0,
          likeCnt: _data.tag_count || 0,
          comCnt: _data.comments.length,
          mine: _data.mine,
          isShowComment: false,
          has_tag: _data.has_tag,
          tag_id: _data.tag && _data.tag.id || '',
          comments: _data.comments.map(function (_, i) {
            return {
              cid: _.id,
              user: {
                url: _.observer.avatar || './icons/default.jpg',
                name: _.observer.nickname,
                time: _.created_time
              },
              text: _.comments,
              mine: _.mine
            }
          })
        },
        answer: _data.answers && _data.answers.map(function (_, i) {
          return {
            aid: _.id,
            user: {
              url: _.replier.avatar || './icons/default.jpg',
              name: _.replier.nickname,
              time: _.created_time
            },
            text: _.contents,
            likeCnt: _.tag_count,
            comCnt: _.comments.length,
            mine: _.mine,
            isShowComment: false,
            has_tag: _.has_tag,
            tag_id: _.tag && _.tag.id || '',
            comments: _.comments.map(function (__, i) {
              return {
                cid: __.id,
                user: {
                  url: __.observer.avatar || './icons/default.jpg',
                  name: __.observer.nickname,
                  time: __.created_time
                },
                text: __.comments,
                mine: __.mine
              }
            })
          }
        }) || []
      }
      callback(json)
    }
  })
}
/* 删除提问 */
const deleteDiscuss = (qid, callback) => {
  util.requestApi({
    url: util.config.URL_PATH + '/ep/v2/qa/questions/' + qid,
    method: 'DELETE',
    callback: function (res) {
      let _data = res.data
      if (_data.success) {
        callback(res)
      }
    }
  })
}
/* 提出问题 */
const publishQues = (param, callback) => {
  util.requestApi({
    url: util.config.URL_PATH + '/ep/v2/qa/questions',
    method: 'POST',
    data: param,
    callback: function (res) {
      let _data = res.data
      callback(res)
    }
  })
}
/* 回答问题 */
const answerQues = (param, callback) => {
  util.requestApi({
    url: util.config.URL_PATH + '/ep/v2/qa/answers',
    method: 'POST',
    data: param,
    callback: function (res) {
      let _data = res.data
      if (_data.success) {
        callback(res)
      }
    }
  })
}
/* 删除回答 */
const deleteAnswer = (aid, callback) => {
  util.requestApi({
    url: util.config.URL_PATH + '/ep/v2/qa/answers/' + aid,
    method: 'DELETE',
    callback: function (res) {
      let _data = res.data
      if (_data.success) {
        callback(res)
      }
    }
  })
}
/* 回复评论 */
const callbackComment = (param, callback) => {
  util.requestApi({
    url: util.config.URL_PATH + '/ep/v2/qa/comments',
    method: 'POST',
    data: param,
    callback: function (res) {
      let _data = res.data
      if (_data.success) {
        callback(res)
      }
    }
  })
}
/* 删除评论 */
const deleteComment = (cid, callback) => {
  util.requestApi({
    url: util.config.URL_PATH + '/ep/v2/qa/comments/' + cid,
    method: 'DELETE',
    callback: function (res) {
      let _data = res.data
      if (_data.success) {
        callback(res)
      }
    }
  })
}
/* 点赞 */
const like = (param, callback) => {
  util.requestApi({
    url: util.config.URL_PATH + '/ep/v2/qa/tags',
    method: 'POST',
    data: param,
    callback: function (res) {
      let _data = res.data
      if (_data.success) {
        callback(res)
      }
    }
  })
}
/* 取消点赞 */
const unlike = (tagid, callback) => {
  util.requestApi({
    url: util.config.URL_PATH + '/ep/v2/qa/tags/' + tagid,
    method: 'DELETE',
    callback: function (res) {
      let _data = res.data
      if (_data.success) {
        callback(res)
      }
    }
  })
}
module.exports = {
  getDiscussList: getDiscussList,
  getCourseDiscussList: getCourseDiscussList,
  getDiscussDetail: getDiscussDetail,
  publishQues: publishQues,
  deleteDiscuss: deleteDiscuss,
  callbackComment: callbackComment,
  deleteComment: deleteComment,
  answerQues: answerQues,
  deleteAnswer: deleteAnswer,
  like: like,
  unlike: unlike
}