// pages/videoPlayer/show.js
const util = require('../../utils/util.js')
const objV = require('./contentVideo/videoCtrl.js')
const objA = require('./contentAudio/audioCtrl.js')

const ChapterApi = require('../../apiService/ChapterApi.js')

Page({
  data: {
    /* 打开页面时，状态 */
    status: {
      isLoading: true, // 页面加载中
      isSupport: true, // 是否支持视频播放
      isSet: false, // 是否点击打开设置面板, 与isVideo和isAudio 互斥，只要其中有一个为 true, 这个isSet就为false
      isAudio: false, // 是否播放音频
      isImages: false, // 是否播放图片
      isVideo: false, // 是否播放视频，独立存在，永远存在，只用isVideo属性控制
      imagesLoaded: false, // 图片是否加载完
    },
    /* 视频地址 */
    video: {
      src: '', // 视频播放地址
      spareSrc: 'http://pd4t7ae3m.bkt.clouddn.com/test.mp4' // 正常视频播放地址，浏览器不支持时，使用备用地址
    },
    /* 音频地址 */
    audio: {
      src: '', // 音频播放地址
      spareSrc: 'http://pd4t7ae3m.bkt.clouddn.com/audio-test.mp3', // 音频备用地址
      poster: 'http://pd4t7ae3m.bkt.clouddn.com/imgs-test3.jpg' // 音频播放封面
    },
    /* PPT对象 */
    image: {
      imgUrls: [
        'http://pd4t7ae3m.bkt.clouddn.com/imgs-test1.jpg',
        'http://pd4t7ae3m.bkt.clouddn.com/imgs-test2.jpg',
        'http://pd4t7ae3m.bkt.clouddn.com/imgs-test3.jpg'
      ], // 所有图片数组
      current: 0, // 当前跟着音视频走，播放的是第几个图片
      selectIndex: 0,
      timeArr: [2, 10] // 时间数组，在这个时间时，图片需要切换到对应下角标图片
    },
    /* 音视频 控制显示 - 变量参数 */
    ctrlBar: {
      isPlay: false, // 是否在播放
      initial_time: 0,
      currentTime: '00:00', // 音视频 播放 当前时间
      totalTime: '00:00', // 音视频 播放 总时间
      progress: '0%', // 播放百分比率
      curRate: '1.0X', // 当前播放倍率
      jumpFlag: false, // 是否跳过片头
      vid: 0 // 当前视频对应的 vid
    },
    /* 课程章节列表 */
    chapterList: {
      isShow: false, // 是否显示列表
      currentChapterId: '11', // 当前章节id
      course: [{
        title: '第一章：重要概念',
        chapters: [
          { id: '11', time: '28:18', name: '1.1 现值（PV）和终值（FV）' },
          { id: '12', time: '19:09', name: '1.2 净现值（NPV）及实际收益率' }
        ]
      }, {
        title: '第二章：证券估值',
        chapters: [
          { id: '21', time: '27:49', name: '2.1 债券和股票的现金流贴现估值方法' },
          { id: '22', time: '16:04', name: '2.2 债券评级及债券协议' },
          { id: '23', time: '', name: '公司金融第二周测验' },
          { id: '24', time: '', name: '公司金融第二周作业' }
        ]
      }],
      nextVideo: {}, // 下一章 音视频对象
      prevVideo: {} // 上一章音视频对象
    },
    /* 初始化后，视频状态设置为true先播放，会增加控制等待按钮，一直等待不能进行其他操作，到达可以播放状态时，再改为false */
    initVAFlag: false,
    /* 从页面传过来的参数 */
    options: null
  },
  /* 本组件当前 this */
  _that: null,
  /* 视频对象 */
  _video: null,
  /* 音频对象 */
  _audio: null,
  /* 接口返回的全部进度数据，用于实时上传进度 */
  realTimeProgress: null,
  /* 心跳机制（注意： 在播放时，打开心跳；在暂停时，关闭心跳） - 全局唯一一个定时器 - 不参与 this.setData  */
  heartbeat: null,
  /* 点击放大图时，属于特殊打开，会调用 onHide，需要特殊处理加标记 */
  isBigPicShow: false,
  /* 是否切换到 后台 */
  isBackend: false,
  /* 第一次进入时 */
  firstOpen: true,
  /* 切换视频时，切换视频时，可能会导致 上次的记录不会播放，这个问题没有解决。IOS 和 android都没有解决 */
  switchOpen: false,
  /* 存储 第一次进入 或 切换时，控制信息的相关数据 */
  _cache: null,
  _cacheTotalTime: 0,
  /* show页面 - 页面内容初始化(首次打开时，data.status本身就是初始状态，则不用再调用statusClear方法进行初始化) - 1. 根据数据初始化音视频对象；2. 根据数据初始化到视频页面；3. 根据进度数据初始化视频进度 */
  initPage: function (res, vid) {
    /* setData、视频设置等 异步，需要时间，所以加个延时，为true时播放按钮不可用 */
    this.setData({ 'initVAFlag': true })
    /* 默认先 显示视频 */
    this.setData({ 'status.isVideo': true })
    this._cache = { isPlay: false, initial_time: 0, currentTime: '00:00', totalTime: '00:00', progress: '0%', curRate: '1.0X', jumpFlag: false, vid: vid }
    /* 加载中时，重置控制内容 全部为 0 */
    this.setData({ 'ctrlBar': this._cache })
    /* 一定会 存在值 */
    if (res) {
      let tempVid = wx.getStorageSync('videoCacheCtrlBar').vid
      if (vid == tempVid) {
        this._cache = wx.getStorageSync('videoCacheCtrlBar') || {}
        res.cpt = Math.max(this._cache.initial_time || '', res.cpt)
      }
      this._cache.initial_time = res.cpt
      this.realTimeProgress = res
    }
    wx.setStorageSync('videoCacheCtrlBar', this._cache);
    wx.setStorageSync('audioCacheCtrlBar', this._cache);
    /* 将旧的对象全部抛弃掉 */
    (!this._video && (this._video = objV.Video('my-video')));
    this._audio = objA.Audio(this.data.audio.src, this);
    /* 切换视频源时 */
    if (this.switchOpen) { this.setData({ 'ctrlBar': this._cache }); this.pauseVA() } 
    /* 第一次进入时 */
    if (this.firstOpen) { this.playVA() }
    setTimeout(() => {
      this.setData({ 'status.isLoading': false })
      /* 这里 设置倍速还有点问题 */
      let _vObj = this._video; for (let i = 0; i < _vObj.RATE.length; i++) { let _ = _vObj.RATE[i]; if (this.data.ctrlBar.curRate.replace(/X/, '') == _) { _vObj.rateIndex = i - 1; this.setRate(); }; }
    }, 200);
  },
  /* 页面初始入口，会 先走 AJAX 读取 章节列表数据、音视频和PPT数据、进度数据 */
  ajaxInitGetInfo: function (vid) {
    let cid = this.data.options.cid, sid = this.data.options.sid, did = 'jjhz92fn0.le2a6c06c9g0.thhg7ekb1f8';
    ChapterApi.getChapterList(cid, sid, vid, (json) => {
      this.setData({ 'chapterList': json })
    })
    ChapterApi.getCurrentChapterDetail(vid, (json) => {
      this.setData({ 'video': json.video })
      this.setData({ 'audio': json.audio })
      this.setData({ 'image': json.image })
      ChapterApi.getProgress(vid, did, sid, (res) => {
        res.did = did
        res.vid = vid
        res.cid = cid
        res.sid = sid
        this.initPage(res, vid)
      })
    })
  },
  onLoad: function (options) { this.data.options = options; },
  onHide: function () { this.isBackend = true; this.pauseVA(); clearInterval(this.heartbeat); },
  onUnload: function () { this.pauseVA(); },
  onShow: function () {
    /* 兼容 android 这里发现 android 打开预览大图，然后关闭 自动播放视频，而且关不掉, 兼容android强制关闭视频 */
    /* 这里没有 预览大图 关闭监听，所以 isBigPicShow 状态永远为 true */
    if (this.isBigPicShow) { this.pauseVA() }
    if (this.isBackend) {
      let tempTime = wx.getStorageSync('videoCacheCtrlBar').initial_time;
      this.playVA();
      /* 兼容 android 突然黑屏关闭，然后一会儿打开，播放时出现跳跃播放问题 */
      this.seekVA(tempTime);
      /* 这里调用，跟初始化调用时保持一致，其主要也是为了解决android从后台进入前台时出现的问题 */
      this.setData({ 'initVAFlag': true });
      this.isBackend = false;
    }
  },
  /* 生命周期函数--监听页面初次渲染完成 */
  onReady: function () { this.ajaxInitGetInfo(this.data.options.vid); },

  /* controlBar页面 - 切换音频页面 - bindTap事件 */
  showContentAudio: function () {
    if (!this.data.audio.src) { wx.showToast({ title: '暂无音频文件', icon: 'none' }); return; }
    this.changeVideoAndAudio({ content: '当前视频将暂停播放，请确认？', setStorage: 'videoCacheCtrlBar', getStorage: 'audioCacheCtrlBar', isAudio: true, isVideo: false });
  },
  /* controlBar页面 - 切换视频页面 - bindTap事件 */
  showContentVideo: function () {
    this.changeVideoAndAudio({ content: '当前音频将暂停播放，请确认？', setStorage: 'audioCacheCtrlBar', getStorage: 'videoCacheCtrlBar', isAudio: false, isVideo: true });
  },
  /* controlBar页面 - 切换音视频页面:辅助方法 - 1. 关闭音频或视频；2. 需要提示；3. 初始化视频记录或音频记录 */
  changeVideoAndAudio: function (obj) {
    this.pauseVA();
    wx.showModal({
      title: '提示', content: obj.content,
      success: (res) => {
        if (res.confirm) {
          wx.setStorageSync(obj.setStorage, obj.getStorage);
          let cache = wx.getStorageSync(obj.getStorage);
          this.setData({ 'ctrlBar': cache });
          this.setData({ 'status.isAudio': obj.isAudio });
          this.setData({ 'status.isVideo': obj.isVideo });
          this.seekVA(cache.initial_time);
          this.playVA();
          /* 这里调用，解决VA视频初始化 */
          this.setData({ 'initVAFlag': true });
        }
      }
    });
  },

  /* controlBar页面 和 selectChapterList页面 - 切换章节列表 - bindTap事件 */
  jumpToOtherVA: function (e) {
    let _data = e.target.dataset;
    if (!_data.hasva) { 
      /* 如果存在 - 课后习题类型， type:3、work_type:1 */
      let i1 = _data.index, i2 = _data.index1
      let _course = this.data.chapterList.course[i1]
      if (_course && _course.chapters[i2] && _course.chapters[i2].homework) {
        let _hw = _course.chapters[i2].homework
        wx.setStorageSync('_homework', _hw)
        wx.navigateTo({
          url: '/pages/learnSystem/courseContent/examDetail/examDetail'
        })
        return;
      }
      wx.showToast({ title: '请在PC上使用该功能', icon: 'none' }); return; 
    }
    this.switchOpen = true;
    this.statusClear(_data.name, _data.id);
    this.ajaxInitGetInfo(_data.id);
  },
  /* controlBar页面 和 selectChapterList页面 - 切换章节列表: 辅助方法 - 1. 暂停视频；2. 关闭章节选择列表；3. 状态清理(status、videoCacheCtrlBar、audioCacheCtrlBar)；4. 设置微信导航头 */
  statusClear: function (name, id) {
    this.pauseVA();
    this.closeSelectChapterList();
    let initStatus = { isLoading: true, isSupport: true, isSet: false, isAudio: false, isImages: false, isVideo: false, imagesLoaded: false };
    this.setData({ 'status': initStatus });
    let initCtrlBar = { isPlay: false, initial_time: 0, currentTime: '00:00', totalTime: '00:00', progress: '0%', curRate: '1.0X', jumpFlag: false, vid: id };
    wx.setStorageSync('videoCacheCtrlBar', initCtrlBar);
    wx.setStorageSync('audioCacheCtrlBar', initCtrlBar);
    wx.setNavigationBarTitle({ title: name || '音视频' });
  },
  /* controlBar页面 - 上一章 - bindTap事件 */
  prevChapter: function (e) { if (!e.target.dataset.id) { wx.showToast({ title: '已经是第一章了.', icon: 'none' }); return; }; this.jumpToOtherVA(e); },
  /* controlBar页面 - 下一章 - bindTap事件 */
  nextChapter: function (e) { if (!e.target.dataset.id) { wx.showToast({ title: '已经是最后一章了.', icon: 'none' }); return; }; this.jumpToOtherVA(e); },
  /* controlBar页面 - 打开切换章节列表 - bindTap事件 */
  openSelectChapterList: function () { this.setData({ 'chapterList.isShow': true }); },
  /* controlBar页面 - 关闭切换章节列表 - bindTap事件和内部调用 */
  closeSelectChapterList: function () { this.setData({ 'chapterList.isShow': false }); },
  /* controlBar页面 - 打开图片轮播页面 - bindTap事件 */
  openContentImages: function () { this.setData({ 'status.isImages': true }); },
  /* controlBar页面 - 关闭图片轮播页面 - bindTap事件 */
  closeContentImages: function () {
    this.setData({ 'status.isImages': false });
    /* 兼容 android 发现打开previewImage后,从swiper 切换回 视频播放页，视频会自动暂停 */
    this.data.status.isVideo && this.pauseVA();
    wx.getStorageSync('videoCacheCtrlBar').isPlay && this.playVA();
  },
  /* controlBar页面 - 打开设置面板 - bindTap事件 */
  openSetContent: function () { this.setData({ 'status.isSet': true }); },
  /* controlBar页面 - 关闭设置面板 - bindTap事件 */
  closeSetContent: function () { this.setData({ 'status.isSet': false }); },

  /* contentImages页面 - 点击放大图 - bindTap事件 */
  showBigImage: function () {
    let _obj = this.data.image
    /* 兼容 android 暂停后 回退回来，视频未暂停还在继续播放，但进度条失去作用，所以需要 onShow中 重新调用 暂停方法 */
    this.isBigPicShow = true
    wx.previewImage({ current: _obj.imgUrls[_obj.selectIndex], urls: _obj.imgUrls })
  },
  /* Swiper标签 - 轮播图切换时 - bindchange事件 */
  imageSelectIndexUpdate: function (e) { this.setData({ 'image.selectIndex': e.detail.current }); },

  /* VideoOrAudio image标签 - 图片开始加载 注意：图片过大时，有个加载状态 */
  imagesLoadBegin: function () { this.setData({ 'status.imagesLoaded': false }) },
  /* contentAudio页面 - 图片加载完成 - bindload事件 */
  imagesLoaded: function () { this.setData({ 'status.imagesLoaded': true }) },
  /* controlBar页面 - 播放音视频 - bindTap事件和内部调用 */
  playVA: function () {
    let _data = this.data, _status = _data.status
    this.setData({ 'ctrlBar.isPlay': true })
    _status.isVideo && this._video.play()
    _status.isAudio && this._audio.play()
    this.setHeartbeat()
  },
  /* controlBar页面 - 暂停音视频 - bindTap事件和内部调用 */
  pauseVA: function () {
    let _data = this.data, _status = _data.status
    this.setData({ 'ctrlBar.isPlay': false })
    _status.isVideo && this._video.pause()
    _status.isAudio && this._audio.pause()
    clearInterval(this.heartbeat)
  },
  /* controlBar页面 - 点击进度条跳到某个位置播放 - bindtouchstart事件 */
  tapToSeek: function (e) { let pLine = wx.getSystemInfoSync().windowWidth - e.currentTarget.offsetLeft * 2, pos = e.touches[0].pageX, _data = this.data, _status = _data.status, _obj = _status.isVideo ? this._video : this._audio; this.seekVA(parseInt(pos / pLine * _obj.totalTime)); },
  /* VideoOrAudio - 跳到某个点开始播放 */
  seekVA: function (time) { let _data = this.data, _status = _data.status; _status.isVideo && this._video.seek(time); _status.isAudio && this._audio.seek(time); },
  /* setContent页面 - 跳过片头 - bindTap事件 */
  jumpHead: function () { this.setData({ 'ctrlBar.jumpFlag': !this.data.ctrlBar.jumpFlag }); },
  /* setContent页面 - 后退15s音视频 - bindTap事件 */
  slow15s: function () { let _data = this.data, _status = _data.status; _status.isVideo && this._video.fastSlow15('-15'); _status.isAudio && this._audio.fastSlow15('-15'); },
  /* setContent页面 - 快进15s音视频 - bindTap事件 */
  fast15s: function () { let _data = this.data, _status = _data.status; _status.isVideo && this._video.fastSlow15('15'); _status.isAudio && this._audio.fastSlow15('15'); },
  /* setContent页面 - 改变播放倍率 注意：音频不支持倍速 - bindTap事件 */
  setRate: function () {
    let _data = this.data, _status = _data.status
    if (_status.isAudio) { wx.showToast({ title: '音频暂不支持倍速', icon: 'none' }); return; }
    let _obj = this._video
    _obj.rate()
    this.setData({ 'ctrlBar.curRate': _obj.RATE[_obj.rateIndex] + 'X' })
  },
  /* 视频进入 或者 退出全屏时 触发 */
  beginAndOutFullScreen: function (e) {},
  /* VideoOrAudio标签 - 开始/继续播放时触发play事件时，触发 - bindplay事件 */
  beginPlayVA: function () {
    if (this.data.initVAFlag) {
      if (this.firstOpen) {
        this.seekVA(this._cache.initial_time)
        /* 由于不能直接获取视频长度，所以 延时暂停，通过 timeUpdate获取视频长度 */
        setTimeout(() => {
          this.pauseVA()
          this.setData({ 'initVAFlag': false })
        }, 260)
      } else {
        this.pauseVA()
        this.setData({ 'initVAFlag': false })
        return ;
      }
    }
    /* 切换时 iphone 6 系统：8.4.1 会存储上一次视频，所以，再手动点击播放时，进行切换到当前位置 */
    if (this.switchOpen) {
      this.seekVA(this._cache.initial_time);
      this.switchOpen = false
    }
  },
  /* VideoOrAudio标签 - 暂停播放时触发pause事件时，触发 - bindpause事件 */
  beginPauseVA: function () {
    if (this.firstOpen) {
      this.setData({ 'ctrlBar.progress': this._cache.initial_time / this._cacheTotalTime * 100 + '%' });
      this.setData({ 'ctrlBar.currentTime': util.durationToTimeString(this._cache.initial_time) });
      this.firstOpen = false
    }
    if (this.switchOpen) {
      this.setData({ 'initVAFlag': false })
    }
  },
  /* VideoOrAudio标签 - 当播放到末尾时，触发 - bindended事件 */
  playEnded: function () { wx.showToast({ title: '当前音/视频播放完毕。', icon: 'none' }); this.pauseVA(); },
  /* VideoOrAudio标签 - 视频播放错误时，触发 - binderror事件 */
  playError: function (e) {  },
  /* VideoOrAudio标签 - 视频播放发生变化时 - bindtimeupdate事件 */
  timeUpdate: function (e) {
    let _data = this.data, _status = _data.status, _detail = e.detail, _obj = _status.isVideo ? this._video : this._audio
    _obj.currentTime = parseInt(_detail.currentTime)
    this._cacheTotalTime = _obj.totalTime = parseInt(_detail.duration)
    this.setData({ 'ctrlBar.progress': _obj.currentTime / _obj.totalTime * 100 + '%' });
    this.setData({ 'ctrlBar.currentTime': util.durationToTimeString(_obj.currentTime) });
    this.setData({ 'ctrlBar.totalTime': util.durationToTimeString(_obj.totalTime) })
    /* 实时改变 当前的PPT当前页 */
    let arr = this.data.image.timeArr
    for (let i = 0; i < arr.length; i++) {
      if (_obj.currentTime >= arr[i] && (i + 1 < arr.length ? _obj.currentTime < arr[i + 1] : 1)) {
        this.setData({ 'image.current': i })
        break
      }
    }
  },

  /* 增加定时器，每过2000ms，把数据存入localStorage一次 并 提交一次 */
  setHeartbeat: function () {
    let _data = this.data
    /* 页面进入时只初始化一次 */
    clearInterval(this.heartbeat)

    this.heartbeat = setInterval(() => {
      /* 如果是初始加载状态，就不计算时间状态 和 提交进度了 */
      if (this.data.initVAFlag) return;
      let arr = _data.ctrlBar.currentTime.split(':'), tempTime = parseInt(arr[0] * 60) + parseInt(arr[1]);
      this.setData({ 'ctrlBar.initial_time': tempTime })
      wx.setStorageSync('videoCacheCtrlBar', _data.ctrlBar)
      wx.setStorageSync('audioCacheCtrlBar', _data.ctrlBar)
      /* 由于 音视频相同，所以 设置方式设置成一致就可以了 */
      /* 提交进度请求 */
      if (this.realTimeProgress) {
        let _rProgress = this.realTimeProgress
        _rProgress.pt = parseInt(_rProgress.pt) + parseInt((tempTime - _rProgress.cpt > 0) && (tempTime - _rProgress.cpt < 8) ? (tempTime - _rProgress.cpt) : 0)
        _rProgress.cpt = tempTime
        _rProgress.mpt = tempTime > _rProgress.mpt ? tempTime : _rProgress.mpt
        ChapterApi.updateProgress(_rProgress)
      }
    }, 1000)
  }
})