/**
 * 所有相关配置项
 */
const config = {
  // URL_PATH: 'http://dev.ezijing.com:3000/api', // 本地开发域名
  // outSiteLink: 'https://applets.ezijing.com', // 本地测试外链
  // URL_PATH: 'https://api2.ezijing.com', // 测试域名
  // outSiteLink: 'https://kelley2.ezijing.com', // 测试外链
  URL_PATH: 'https://api.ezijing.com', // 正式域名
  outSiteLink: 'https://e-learning.ezijing.com', // 正式外链
}
/* 请求接口统一 重定义 */
const requestApi = (obj) => {
  wx.request({
    url: obj.url,
    data: obj.data || '', // 不必填
    header: {
      'skey': wx.getStorageSync('userSession').sessionKey,
      'tenant': 'classes',
      'content-type': 'application/x-www-form-urlencoded',
      // 测试用
      // 'Cookie': '_idt=jjhz92fn0.le2a6c06c9g0.thhg7ekb1f8; _ga=GA1.2.1777311393.1531910388; Hm_lvt_64d86060eda3e464ab4928484860b4ea=1531998677; pt_37c2513b=uid=K0MVCaW1zOQbL9Hlh4nwcA&nid=0&vid=j38J/KRanp7TFqxsiK0Ryw&vn=14&pvn=3&sact=1533523932802&to_flag=0&pl=NbnhKybdedL6K-YTE0zzsQ*pt*1533523932802; _pk_id.8.50b6=5e9684d55d7b51d1.1534129436.5.1534223988.1534222943.; Hm_lvt_35891a16eff03ec8bb219e4a00dbaf7a=1534307203; looyu_id=3aa78c2b7a744584f9f6fef015c4157b66_10036753%3A6; Qs_lvt_217181=1534307202; pt_s_6d83a9d6=vt=1534308606705&cad=; Hm_lpvt_35891a16eff03ec8bb219e4a00dbaf7a=1534308607; Qs_pv_217181=4039008301502242300%2C2643992663734177300%2C23948192170497664%2C3823352575569261000; pt_6d83a9d6=uid=EXg24v5T9wUibq5/wWWZCg&nid=0&vid=4NDbaXQ0RlX8HEv7TTSzkA&vn=8&pvn=2&sact=1534308606705&to_flag=1&pl=Rcddj0FCL0MTlYRofJeCeA*pt*1534308606705; Hm_lvt_81efeffaf531027591c4d577ee4a5cb4=1533525823,1534473796; _SUP=00da585a6b1b53bd453d1b30cbf9812ff9ef0313e4f5756651f3218543452c27a%3A2%3A%7Bi%3A0%3Bs%3A4%3A%22_SUP%22%3Bi%3A1%3Bs%3A144%3A%22MFpTR3h1QmtTSlM1Z3JvLmVscG1heGUuMTBzYWMtZWRPWnFoeDdsMFlCTkFiTFNjZFl3UVVDZkVwa3N3UlgxZEFVQTlkTnFhRU54c3RLUGEtMTI1LVRHVDAuNDI3NDQ0ODQ4ODA1MzQ5MDU%3D%22%3B%7D; Hm_lpvt_81efeffaf531027591c4d577ee4a5cb4=1535072424; _pk_id.7.50b6=a73f1add4efca30d.1531815381.52.1535110040.1535110040.; _pk_ses.7.50b6=*'
    },
    method: obj.method || 'GET', // 不必填，默认 GET
    dataType: 'json',
    success: function (res) {
      if (res.statusCode === 200) { 
        // if (res.data.status === 200) {
        //   obj.callback(res.data) // 直接把数据处理好，然后直接 返回 
        // } else {
        //   wx.showToast({ title: JSON.stringify(res.data), icon: 'none' }) // 自己后台封装返回
        // }
        obj.callback(res)
      } else {
        wx.showToast({ title: res.errMsg, icon: 'none' }) // 微信封装返回
      }
    },
    fail: function (res) {
      wx.showToast({ title: JSON.stringify(res), icon: 'none' })
    }
  })
}
/* 工具方法 - 播放时间 转化 h:m:s */
const durationToTimeString = (duration) => {
  let h = Math.floor(duration / 3600);
  let m = Math.floor((duration - h * 3600) / 60);
  let s = (duration - h * 3600 - m * 60) % 60;
  function tenify(a) {
    return a >= 10 ? a : '0' + a;
  }
  let to = { h: tenify(h), m: tenify(m), s: tenify(s) }
  let format = 'h:m:s';
  return format.replace(/h|m|s/g, k => to[k]).replace(/^00\:/, '');
}

/**
 * 小程序 - 获取用户信息
 */
const miniGetInfo = (callback) => {
  // 获取用户凭证code - 使用 login API获取
  wx.login({
    success: res => {
      let obj = {}
      obj.code = res.code
      // 获取用户授权设置 - 使用 getSetting API获取
      wx.getSetting({
        success: res1 => {
          if (res1.authSetting['scope.userInfo']) {
            // 获取用户信息 - 使用 getUserInfo API获取
            wx.getUserInfo({
              withCredentials: true,
              success: res2 => {
                obj.encryptedData = res2.encryptedData
                obj.iv = res2.iv
                obj.userInfo = res2.userInfo
                /**
                 * 这里 调用后台接口 loginApi，传参如下
                 * obj.code
                 * obj.encryptedData
                 * obj.iv
                 * obj.userInfo
                 */
                loginApi(obj, (res, obj) => { callback(res, obj); })
              },
              fail: res2 => { wx.hideLoading(); wx.showToast({ title: '用户信息获取失败，请重试', icon: 'none' }); }
            })
          } else {
            wx.hideLoading(); wx.showToast({ title: '请先点击登录', icon: 'none' });
          }
        },
        fail: res1 => { wx.hideLoading(); wx.showToast({ title: '用户授权设置获取失败，请重试', icon: 'none' }); }
      })
    },
    fail: res => { wx.hideLoading(); wx.showToast({ title: '用户凭证code获取失败，请重试', icon: 'none' }); }
  })
}

/**
 * 登录api - 获取 openId 、userName等内容
 */
const loginApi = (obj, callback) => {
  wx.request({
    url: config.URL_PATH + '/ep/user/applets-login', 
    data: { code: obj.code, encrypted_data: obj.encryptedData, iv: obj.iv }, method: 'POST', header: {
      tenant: 'classes'
    }, 
    success: res => { callback(res, obj); }
  })
}

/**
 * 小程序 - 判断是否需要再次登录 并 跳转页面
 */
const LoginAgainAndJumpPage = (callback) => {
  let userSession = wx.getStorageSync('userSession') || {}
  let _userInfo = wx.getStorageSync('userInfo') || {}
  /* 可能存在，多微信绑定同一个手机问题，所以这里暂时不再做鉴定，永远重新请求 */
  // if (userSession.sessionKey && _userInfo.nickName) {
  //   wx.checkSession({
  //     success: () => {
  //       callback()
  //     }, // session_key 未过期，并且在本生命周期一直有效
  //     fail: () => {
  //       // session_key 已经失效，需要重新执行登录流程
  //       miniGetInfo((res, obj) => { callback(res, obj); }) 
  //     }
  //   })
  // } else {
  //   // session_key 未存本地，则本地数据缺失
  //   miniGetInfo((res, obj) => { callback(res, obj); }) 
  // }
  miniGetInfo((res, obj) => { callback(res, obj); }) 
}


module.exports = {
  config: config,
  requestApi: requestApi,
  durationToTimeString: durationToTimeString,
  LoginAgainAndJumpPage: LoginAgainAndJumpPage,
}
/**
 * localStorage 中存放的 各种值
 * userSession - 调用 login 获取对应的 sessionKey openId等值
 * userInfo - 存放用户 头像、昵称等基本信息值
 * 
 * videoCacheCtrlBar
 * audioCacheCtrlBar
 */