import httpRequest from '../utils/request.js'

/**
 * 获取课程详情
 * @param {string} semesterId 学期ID
 * @param {string} courseId 课程ID
 */
export function getCourse(semesterId, courseId) {
  return httpRequest.get(`/api/lms/v3/education/courses/${semesterId}/${courseId}`).then(response => {
    response.chapters = response.chapters.filter(item => {
      item.children = item.children.filter(child => child.type === 2 && child.resource_id)
      return item.children.length
    })
    return response
  })
}

/**
 * 获取章节资源详情
 * @param {string} vid 章节的资源ID
 */
export function getChapterVideo(vid) {
  return httpRequest.post('/api/lms/v2/education/aliyun-video-streaming', { vid })
}

/**
 * 获取章节视频播放进度
 * @param {string} semesterId 学期ID
 * @param {string} resourseId 章节的资源ID
 * @param {Object} params
 */
export function getChapterVideoProgress(semesterId, resourseId, params) {
  return httpRequest.get(`/api/lms/v2/education/video/${semesterId}/${resourseId}/device`, params)
}

/**
 * 更新章节视频播放进度
 * @param {Object} params
 */
export function updateChapterVideoProgress(params) {
  return httpRequest.get('/api/lms/v2/analytics/upload-video', params)
}
