const util = require('../utils/util.js')
/**
 * 本API中全部用于 消息 相关接口
 */

/* 获取我的消息信息 */
const getMyMsg = callback => {
  util.requestApi({
    url: util.config.URL_PATH1 + '/v2/education/message/my',
    callback: function (res) {
      let list = Array.isArray(res.data) ? res.data : res.data.list || []
      let json = list.map(function (_, i) {
        return {
          isRead: _.status === 1,
          id: _.id,
          text: _.message_body,
          time: _.created_time,
          isShow: false // 该字段用来做 每条信息的打开、关闭
        }
      })
      callback(json)
    }
  })
}
// 读消息
const readMessage = (messageId, callback) => {
  util.requestApi({
    url: util.config.URL_PATH1 + `/v2/education/message/${messageId}`,
    method: 'POST',
    callback: function (res) {
      callback(res.data)
    }
  })
}
module.exports = {
  getMyMsg: getMyMsg,
  readMessage
}
