import * as api from './api/base.js'

App({
  store: {
    pageshow: false,
    user: {} // 用户信息
  },
  onLaunch: function () {},
  onPageNotFound() {
    wx.redirectTo({ url: 'pages/login/index' })
  },
  checkPageshow(callback) {
    if (this.store.pageshow) {
      callback && callback(true)
      return true
    }
    wx.showNavigationBarLoading()
    api.getPageShowStatus().then(response => {
      const show = response.code === 1
      this.store.pageshow = show
      callback && callback(show, response)
      wx.hideNavigationBarLoading()
    })
  },
  // 获取用户信息
  getUser() {
    return api.getUser().then(response => {
      this.store.user = response
      wx.setStorage({ key: 'uid', data: response.id })
      wx.setStorage({ key: 'sid', data: response.student_info.id })
      return response
    })
  },
  // 退出登录
  logout() {
    return api.logout().then(response => {
      wx.removeStorageSync('token')
    })
  }
})
