// pages/learnSystem/courseContent/examDetail/examDetail.js
const CourseApi = require('../../../../apiService/CourseApi.js')

Page({
  /**
   * 页面的初始数据
   */
  data: {
    exam: {
      id: '',
      semester_id: '',
      title: '家族财富传承第一章试题',
      score: '',
      work_contents: '',
      group: [{
        id: '',
        type: 1, // 判别是 单选还是多选
        title: '<p>一般延续好几代，采取防御战略维持企业的家族企业类型是（ ）。</p>',
        arr: [
          { id: '', checked: false, option: '闪电型', selected: 0 },
          { id: '', checked: false, option: '不老型', selected: 0 },
          { id: '', checked: false, option: '长存型', selected: 0 },
          { id: '', checked: false, option: '持续创业型', selected: 0 }
        ],
        cur: ''
      }]
    }
  },
  // 提交时，传入的参数值
  param: { 
    course_id: '',
    chapter_id: '',
    work_id: '',
    semester_id: '',
    work_contents: '',
    duration: 0,
    score: 0
  },
  /* 进入页面记录初试时间 */
  startTime: '',
  /* 记录所有题目是否都答过 */
  recordAll: [],

  arrRandomSort: function (arr) {
    /* 对json.questions 进行一次乱序排列 */
    let tmpJson = null

    tmpJson = arr.shift()
    arr.push(tmpJson)
    tmpJson = arr.shift()
    arr.push(tmpJson)
    tmpJson = arr.shift()
    arr.push(tmpJson)
  },
  unArrRandomSort: function (arr) {
    /* 取消乱序排列，恢复原顺序 */
    let tmpJson = null

    tmpJson = arr.pop()
    arr.unshift(tmpJson)
    tmpJson = arr.pop()
    arr.unshift(tmpJson)
    tmpJson = arr.pop()
    arr.unshift(tmpJson)
  },
  /**
   * 将返回值 - 对照到对应 data上
   */
  updateData: function (json) {
    this.param = {
      course_id: json.course_id,
      chapter_id: json.chapter_id,
      work_id: json.work_id,
      semester_id: json.semester_id,
      work_contents: '',
      duration: 0,
      score: 0
    }
    this.startTime = new Date().getTime()
    this.arrRandomSort(json.questions)
    let _data = {
      id: json.id,
      semester_id: json.semester_id,
      title: json.work_title,
      score: json.score || '',
      work_contents: json.work_contents || '',
      group: json.questions.map(function (_, i) {
        let str = '', _json = JSON.parse(_.question_options)
        /* 答过题目时 */
        if (json.work_contents) {
          let a = JSON.parse(json.work_contents)
          for (let i = 0; i < a.length; i++) {
            if (a[i].question_id == _.id) {
              _json = a[i].options
              break
            }
          }
        }
        _json.forEach(function (__, j) {
          if (__.checked) {
            switch(j) {
              case 0: str += 'A,'; break;
              case 1: str += 'B,'; break;
              case 2: str += 'C,'; break;
              case 3: str += 'D,'; break;
              case 4: str += 'E,'; break;
              case 5: str += 'F,'; break;
              case 6: str += 'G,'; break;
              case 7: str += 'H,'; break;
              case 8: str += 'I,'; break;
              case 9: str += 'J,'; break;
            }
          }
        })
        return {
          id: _.id,
          type: _.question_type,
          title: _.question_content,
          arr: _json,
          cur: json.work_contents && str.substr(0, str.length-1) || ''
        }
      })
    }
    return _data
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    wx.showLoading({ title: '页面加载中...', mask: true })
    if (wx.getStorageSync('_homework')) {
      this.setData({ 'exam': this.updateData(wx.getStorageSync('_homework')) })
    }
    CourseApi.getExamDetail(this.data.exam.id, this.data.exam.semester_id, this.param.course_id, (res) => {
      let _data = res.data
      let json = _data.homework
      if (json) {
        json.score = _data.score
        json.work_contents = _data.work_contents
        this.setData({ 'exam': this.updateData(json) })
      }
      wx.hideLoading()
    })
    wx.setNavigationBarTitle({ title: this.data.exam.title || '试题' })
  },
  /**
   * radio选择
   */
  radioChange: function (e) {
    let i = e.currentTarget.dataset.index, arr = this.data.exam.group[i].arr, value = e.detail.value
    for (let j = 0; j < arr.length; j++) {
      arr[j]['selected'] = 0
    }
    arr[value].selected = 1
    let cname = 'exam.group[' + i + '].arr'
    this.setData({ [cname]: arr })
    this.recordAll.push(i)
  },
  /**
   * checkbox选择
   */
  checkboxChange: function (e) {
    let i = e.currentTarget.dataset.index, arr = this.data.exam.group[i].arr, value = e.detail.value
    for (let j = 0; j < arr.length; j++) {
      arr[j]['selected'] = 0
    }
    for (let j = 0; j < value.length; j++) {
      arr[value[j]].selected = 1
    }
    let cname = 'exam.group[' + i + '].arr'
    this.setData({ [cname]: arr })
    if (!value.length) {
      this.recordAll = this.recordAll.filter(function (_, m) { return _ != i })
    } else {
      this.recordAll.push(i)
    }
  },
  /**
   * 提交试题
   */
  submitExam: function (e) {
    if (e.currentTarget.dataset.submit) { wx.showToast({ title: '已做过，不能再提交', icon: 'none' }); return ; }
    /* 计算答题时间 */
    this.param.duration = Math.floor((new Date().getTime() - this.startTime)/1000)
    let group = this.data.exam.group, total = group.length, arr = [], score = 0, correct = 0
    for (let m = 0; m < total; m++) {
      let n = 0
      for (; n < this.recordAll.length; n++) {
        if (this.recordAll[n] == m) { break }
      }
      if (n == this.recordAll.length) { wx.showToast({ title: '还有题目未做，不能提交', icon: 'none' }); return; }
    }
    /* 重新定义 - 上传字段 并计算分数 */
    // is_correct
    for (let i = 0; i< group.length; i++) {
      correct = 0
      if (group[i].type == 1) { // 单选的正确 判断
        group[i].arr.forEach(function (_, i) {
          if (_.checked && _.selected) { correct = 1; score += 1 }
        })
      }
      if (group[i].type == 2) { // 多选的正确 判断
        let flag = true
        group[i].arr.forEach(function (_, i) {
          if (_.checked != _.selected) { flag = false }
        })
        if (flag) { correct = 1; score += 1 }
      }
      arr.push({
        question_id: group[i].id,
        is_correct: correct,
        options: group[i].arr
      })
    }
    this.unArrRandomSort(arr)
    this.param.work_contents = JSON.stringify(arr)
    this.param.score = (score/total*100).toFixed(1);
    wx.showLoading({ title: '提交中...', mask: true })
    CourseApi.submitExamDetail(this.param, (res) => {
      if (res.data.status) {
        CourseApi.getExamDetail(this.data.exam.id, this.data.exam.semester_id, this.param.course_id, (res) => {
          let _data = res.data
          let json = _data.homework
          if (json) {
            json.score = _data.score
            json.work_contents = _data.work_contents
            this.setData({ 'exam': this.updateData(json) })
          }
          wx.hideLoading()
        })
      } else {
        wx.showToast({ title: res.data.data.error, icon: 'none' })
        wx.hideLoading()
      }
    })
  },
  /* 重做试题 */
  repeatExam: function (e) {
    this.setData({ 'exam': this.updateData(wx.getStorageSync('_homework')) })
    wx.pageScrollTo({ scrollTop: 0 })
  },
  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () { },
  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () { },
  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () { },
  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () { },
  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () { },
  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () { },
  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () { }
})