// pages/learnSystem/courseContent/publishDiscuss/publishDiscuss.js
const DiscussApi = require('../../../../apiService/DiscussApi.js')

Page({
  /**
   * 页面的初始数据
   */
  data: {
    publish: {
      course_id: '',
      semester_id: '',
      title: '',
      contents: ''
    }
  },
  /* title输入 离开 input blur事件监听 */
  inputTitle: function (e) { this.setData({ 'publish.title': e.detail.value }); },
  /* contents输入 离开 input blur事件监听 */
  inputContents: function (e) { this.setData({ 'publish.contents': e.detail.value }); },
  /* 提交发布问题 */
  submitPublish: function () {
    let _publish = this.data.publish
    if (!_publish.title) { wx.showToast({ title: '请填入问题名称', icon: 'none' }); return; }
    if (!_publish.contents) { wx.showToast({ title: '请填入问题描述', icon: 'none' }); return; }
    wx.showLoading({ title: '操作中...', mask: true })
    DiscussApi.publishQues(this.data.publish, (json) => {
      wx.hideLoading()
      wx.navigateBack({ delta: 1 })
    }) 
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) { 
    if (!options.cid || !options.sid) {
      wx.switchTab({ url: '/pages/learnSystem/home/home' })
    }
    this.setData({ 'publish.course_id': options.cid, 'publish.semester_id': options.sid })
  },
  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () { },
  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {},
  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () { },
  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () { },
  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () { },
  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () { },
  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () { },
})