// pages/learnSystem/message/message.js
const MsgApi = require('../../../apiService/MsgApi.js')

Page({
  /**
   * 页面的初始数据
   */
  data: {
    msgList: [
      //   {
      //   isRead: false,
      //   id: '1',
      //   text: '2017年春季班三期班第三学期课程已经正式开始，作业截止提交时间为2018年1月10日，请三期班同学们合理安排学习时间。2017年春季班三期班第三学期课程已经正式开始，作业截止提交时间为2018年1月10日，请三期班同学们合理安排学习时间。',
      //   time: '2015-05-22 15:51',
      //   isShow: false // 该字段用来做 每条信息的打开、关闭
      // }
    ]
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    wx.showLoading({ title: '页面加载中...', mask: true })
    MsgApi.getMyMsg(json => {
      this.setData({ msgList: json })
      wx.hideLoading()
    })
  },
  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {},
  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {},
  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {},
  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {},
  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {
    // 显示顶部刷新图标
    wx.showNavigationBarLoading()
    wx.showLoading({ title: '更新中...', mask: true })
    MsgApi.getMyMsg(json => {
      this.setData({ msgList: json.list })
      wx.hideLoading()
      // 隐藏导航栏加载框
      wx.hideNavigationBarLoading()
      // 停止下拉动作
      wx.stopPullDownRefresh()
    })
  },
  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {},
  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {},
  /**
   * 是否可以打开查看消息
   */
  canishow: function (e) {
    const { index: i, id } = e.currentTarget.dataset
    let cname = 'msgList[' + i + '].isShow'
    this.setData({ [cname]: !this.data.msgList[i].isShow })
    cname = 'msgList[' + i + '].isRead'
    !this.data.msgList[i].isRead &&
      MsgApi.readMessage(id, res => {
        console.log(res)
      })
    this.setData({ [cname]: true })
    /* 如果需要，再调用已读接口 */
  },
  /**
   * 滚动到底部，加载更多数据
   */
  loadmore: function () {
    wx.showLoading({ title: '数据加载中...', mask: true })
    setTimeout(function () {
      wx.showToast({ title: '没有更多了', icon: 'none' })
      wx.hideLoading()
    }, 2000)
  }
})
