// pages/learnSystem/myDiscuss/myDiscuss.js
const DiscussApi = require('../../../apiService/DiscussApi.js')

Page({
  /**
   * 页面的初始数据
   */
  data: {
    tabs: [{
      title: '我提出的问题',
      isShow: true,
      path: '/my'
    }, {
      title: '我参与的问题',
      isShow: false,
      path:'/involved'
    }],
    discussList: [
    //   {
    //   user: {
    //     url: '',
    //     name: '用户名000',
    //     time: '2018-2-12 15:28:47'
    //   },
    //   title: '这是一个一句话问题这是一个一句话问题这是一个一句话问题标题这是一个一句话问题',
    //   text: '<p>王家有三兄弟甲、乙、丙，丙幼年时送给胡某作养子，丙结婚时，胡某为其盖了新房，后因失火致使该房屋被烧毁。丙的生父母就将自己<p>',
    //   askCnt: 20,
    //   TouCnt: 100,
    //   courseName: '在线学习课程'
    // }
    ]
  },
  param: {
    limit: 10, // 默认每页显示10条
    offset: 0 // 偏移量（未考虑传输时，产生新问题情况）
  },
  loadAjax: function () {
    wx.showLoading({ title: '页面加载中...', mask: true })
    let pathUrl = '';
    for (let i = 0; i < this.data.tabs.length; i++) {
      if (this.data.tabs[i].isShow) {
        pathUrl = this.data.tabs[i].path
      }
    }
    DiscussApi.getDiscussList(pathUrl, this.param, (json) => {
      this.setData({ 'discussList': json })
      wx.hideLoading()
    })
  },
  /**
   * 切换 - tab
   */
  tabSelect: function (e) {
    let index = e.currentTarget.dataset.index
    let json = this.data.tabs
    for (let i = 0; i < json.length; i++) {
      json[i].isShow = false
    }
    json[index].isShow = true
    this.setData({ 'tabs': json })
    this.param.offset = 0
    this.loadAjax()
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) { this.loadAjax(); },
  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () { },
  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () { this.loadAjax(); },
  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () { },
  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () { },
  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () { },
  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () { },
  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () { },
  /**
   * 跳转到对应 问题详情页
   */
  goDiscussDetail: function (e) {
    let qid = e.currentTarget.dataset.id
    wx.navigateTo({
      url: '/pages/learnSystem/discussDetail/discussDetail?qid=' + qid
    })
  },
  /**
   * 上拉加载更多
   */
  loadmore: function () {
    wx.showLoading({ title: '加载中...', mask: true })
    let pathUrl = '';
    for (let i = 0; i < this.data.tabs.length; i++) {
      if (this.data.tabs[i].isShow) {
        pathUrl = this.data.tabs[i].path
      }
    }
    let _data = this.data.discussList
    this.param.offset = _data.length
    DiscussApi.getDiscussList(pathUrl, this.param, (json) => {
      Array.prototype.push.apply(_data, json)
      json.length && this.setData({ 'discussList': _data })
      wx.hideLoading()
      !json.length && wx.showToast({ title: '没有更多了', icon: 'none' })
    })
  },
  /**
   * 下拉刷新
   */
  updatenew: function () {
    wx.showLoading({ title: '更新中...', mask: true })
    let pathUrl = '';
    for (let i = 0; i < this.data.tabs.length; i++) {
      if (this.data.tabs[i].isShow) {
        pathUrl = this.data.tabs[i].path
      }
    }
    this.param.offset = 0
    DiscussApi.getDiscussList(pathUrl, this.param, (json) => {
      this.setData({ 'discussList': json })
      wx.hideLoading()
      wx.showToast({ title: '已更新', icon: 'none' })
    })
  }
})