import * as api from './api.js'

Page({
  data: {
    account: '',
    password: ''
  },
  onLoad: function (options) {},
  // 处理提交
  handleSubmit(e) {
    const { account, password } = this.data
    const params = {
      account,
      password,
      type: 1,
      service: 'https://h5.ezijing.com'
    }
    if (!account) {
      wx.showToast({ title: '请输入邮箱/手机号', icon: 'none' })
      return
    }
    if (!password) {
      wx.showToast({ title: '请输入密码', icon: 'none' })
      return
    }
    this.handleRequest(params)
  },
  // 请求接口
  handleRequest(params) {
    api.login(params).then(response => {
      const { code, msg, data } = response
      code === 0 ? this.handleSuccess(data) : wx.showToast({ title: msg, icon: 'none' })
    })
  },
  // 登录成功
  handleSuccess(data) {
    wx.setStorage({ key: 'token', data: data.TGC })
    wx.switchTab({ url: '/pages/learnSystem/home/home' })
  },
  handlePassword() {
    wx.navigateTo({ url: '/pages/login/password' })
  }
})
