import httpRequest from '../../utils/request.js'

/**
 * 登录
 */
export function login(data) {
  return httpRequest.post('/api/passport/rest/login', data)
}
/**
 * 微信登录
 * @param {string} code 小程序登录授权，获取的code
 * @param {string} identity 小程序项目识别字符串
 */
export function wechatLogin(data) {
  return httpRequest.post('/api/passport/rest/wechat/applets-login', data)
}
// 获取微信unionid
export function getUnionid() {
  return httpRequest.get('/api/passport/rest/wechat/get-applets-unionid')
}
// 绑定微信并登录
export function bindWechat(data) {
  return httpRequest.post('/api/passport/rest/wechat/bind-unionid', data)
}
// 解除微信绑定
export function destoryUnionid() {
  return httpRequest.get('/api/usercenter/user/destory-unionid')
}
// 发送验证码
export function sendCode(data) {
  return httpRequest.post('/api/usercenter/user/send-code', data)
}
// 忘记密码
export function updatePassword(data) {
  return httpRequest.post('/api/usercenter/user/update-pwd', data)
}
// 获取用户信息
export function getUser() {
  return httpRequest.get('/api/lms/user/getinfo')
}
