import * as api from '../../api'
Component({
  /**
   * 组件的属性列表
   */
  properties: {
    unionid: { type: String }
  },

  /**
   * 组件的初始数据
   */
  data: {
    account: '',
    password: ''
  },

  /**
   * 组件的方法列表
   */
  methods: {
    // 处理提交
    handleSubmit(e) {
      const { unionid, account, password } = this.data
      const params = { unionid, account, password, type: 1 }
      if (!account) {
        wx.showToast({ title: '请输入邮箱/手机号', icon: 'none' })
        return
      }
      if (!password) {
        wx.showToast({ title: '请输入密码', icon: 'none' })
        return
      }
      this.handleRequest(params)
    },
    // 请求接口
    handleRequest(params) {
      api.bindWechat(params).then(response => {
        const { code, msg, data } = response
        code === 0 ? this.handleSuccess(data) : wx.showToast({ title: msg, icon: 'none' })
      })
    },
    // 登录成功
    handleSuccess(data) {
      wx.setStorage({ key: 'token', data: data.TGC })
      wx.switchTab({ url: '/pages/learnSystem/home/home' })
    }
  }
})
