import * as api from '../../api'
Component({
  /**
   * 组件的属性列表
   */
  properties: {
    unionid: { type: String }
  },

  /**
   * 组件的初始数据
   */
  data: {
    account: '',
    password: '',
    disabled: false
  },

  /**
   * 组件的方法列表
   */
  methods: {
    // 处理提交
    handleSubmit(e) {
      const { unionid, account, password } = this.data
      const params = { unionid, account, code: password, type: 2 }
      if (!account) {
        wx.showToast({ title: '请输入手机号', icon: 'none' })
        return
      }
      if (!password) {
        wx.showToast({ title: '请输入验证码', icon: 'none' })
        return
      }
      this.handleRequest(params)
    },
    // 请求接口
    handleRequest(params) {
      api.bindWechat(params).then(response => {
        const { code, msg, data } = response
        code === 0 ? this.handleSuccess(data) : wx.showToast({ title: msg, icon: 'none' })
      })
    },
    // 登录成功
    handleSuccess(data) {
      wx.setStorage({ key: 'token', data: data.TGC })
      wx.switchTab({ url: '/pages/learnSystem/home/home' })
    },
    // 发送验证码
    handleSendCode() {
      if (this.data.disabled) {
        return
      }
      if (!/^1[3-9][0-9]{9}$/.test(this.data.account)) {
        wx.showToast({ title: '请输入手机号', icon: 'none' })
        return
      }
      this.handleSendCodeRequest()
    },
    handleSendCodeRequest() {
      this.setData({ disabled: true })
      // 开始倒计时
      const countdown = this.selectComponent('.countdown')
      countdown.start()
      api
        .sendCode({ account: this.data.account })
        .then(response => {
          const { code, msg } = response
          if (code === 0) {
            wx.showToast({ title: '验证码发送成功', icon: 'none' })
          } else {
            countdown.reset()
            this.setData({ disabled: false })
            wx.showToast({ title: msg, icon: 'none' })
          }
        })
        .catch(response => {
          countdown.reset()
          this.setData({ disabled: false })
        })
    }
  }
})
