Component({
  /**
   * 组件的属性列表
   */
  properties: {
    step: { type: Number, value: 1000 },
    seconds: { type: Number, value: 60 }
  },
  /**
   * 组件的初始数据
   */
  data: {
    disabled: false,
    buttonText: '获取验证码',
    currentSeconds: 0
  },
  timer: null,
  /**
   * 组件的方法列表
   */
  methods: {
    genTimer() {
      this.timer && clearInterval(this.timer)
      this.timer = setInterval(() => {
        const currentSeconds = ++this.data.currentSeconds
        this.setData({ currentSeconds, buttonText: `等待(${this.data.seconds - currentSeconds}S)` })
        if (currentSeconds === this.data.seconds) {
          this.finish()
        }
      }, this.data.step)
    },
    // 开始
    start() {
      if (this.data.disabled) {
        return
      }
      this.setData({ disabled: true })
      this.genTimer()
      this.triggerEvent('start')
    },
    // 重置
    reset() {
      this.setData({ disabled: false, currentSeconds: 0, buttonText: '获取验证码' })
      this.timer && clearInterval(this.timer)
    },
    // 结束
    finish() {
      this.reset()
      this.triggerEvent('finish')
    }
  }
})
