import * as api from './api'

Page({
  /**
   * 页面的初始数据
   */
  data: {
    type: 2, // 1 账号密码登录; 2 验证码登录
    show: false, // 绑定状态模态框
    unionid: ''
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    // 授权过的自动登录
    // wx.getSetting({
    //   success: res => {
    //     res.authSetting['scope.userInfo'] && this.wechatLogin()
    //   }
    // })
  },
  // 切换绑定方式
  changeType(e) {
    const { type } = e.currentTarget.dataset
    this.setData({ type })
  },
  // 获取用户code
  getCode(callback) {
    return new Promise((resolve, reject) => {
      wx.login({
        success(res) {
          if (res.code) {
            callback && callback(res.code)
            resolve(res.code)
          } else {
            wx.showToast({ title: `登录失败！${res.errMsg}`, icon: 'none' })
            reject(res)
          }
        },
        fail(res) {
          wx.showToast({ title: `登录失败！${res.errMsg}`, icon: 'none' })
          reject(res)
        }
      })
    })
  },
  // 获取用户信息
  getUserInfo(callback) {
    return new Promise((resolve, reject) => {
      wx.getUserProfile({
        desc: '登录注册',
        success(res) {
          callback && callback(res)
          resolve(res)
        },
        fail(res) {
          wx.showToast({ title: `获取用户信息失败！`, icon: 'none' })
          reject(res)
        }
      })
    })
  },
  // 微信登录
  wechatLogin() {
   // 获取code
    const p1 = this.getCode()
    // 获取用户信息
    const p2 = this.getUserInfo()
    Promise.all([p1, p2]).then(([code, user]) => {
      const { encryptedData, iv } = user
        api.wechatLogin({ encryptedData, iv, code, identity: 'caas-mini' }).then(response => {
          if (response.code === 0) {
            this.handleSuccess(response.data)
          } else if (response.code === 2) {
            // 绑定手机号
            this.setData({ show: true, unionid: response.data.unionid })
          } else {
            wx.showToast({ title: response.msg, icon: 'none' })
          }
        })
    })
  },
  // 手机号登录
  phoneLogin() {
    wx.navigateTo({ url: '/pages/login/phone' })
  },
  // 账号密码登录
  accountLogin() {
    wx.navigateTo({ url: '/pages/login/account' })
  },
  // 登录成功
  handleSuccess(data) {
    wx.setStorage({ key: 'token', data: data.TGC })
    wx.switchTab({ url: '/pages/learnSystem/home/home' })
  }
})
