import * as api from './api.js'

Page({
  data: {
    account: '',
    code: '',
    password: '',
    passwordR: '',
    disabled: false
  },
  onLoad: function (options) {},
  // 处理提交
  handleSubmit(e) {
    const { account, code, password, passwordR } = this.data
    const params = { account, code, password, passwordR }
    if (!account) {
      wx.showToast({ title: '请输入邮箱/手机号', icon: 'none' })
      return
    }
    if (!code) {
      wx.showToast({ title: '请输入验证码', icon: 'none' })
      return
    }
    if (!password) {
      wx.showToast({ title: '请输入密码', icon: 'none' })
      return
    }
    if (password.length < 6) {
      wx.showToast({ title: '密码长度必须大于6位数', icon: 'none' })
      return
    }
    if (password !== passwordR) {
      wx.showToast({ title: '两次输入密码不一样', icon: 'none' })
      return
    }
    this.handleRequest(params)
  },
  // 请求接口
  handleRequest(params) {
    api.updatePassword(params).then(response => {
      const { code, msg, data } = response
      code === 0 ? this.handleSuccess(data) : wx.showToast({ title: msg, icon: 'none' })
    })
  },
  // 修改成功
  handleSuccess(data) {
    wx.showModal({
      content: '密码修改成功',
      showCancel: false,
      confirmText: '去登录',
      success(res) {
        wx.navigateTo({ url: '/pages/login/index' })
      }
    })
  },
  // 发送验证码
  handleSendCode() {
    if (this.data.disabled) {
      return
    }
    if (!(/^1[3-9]\d{9}$/.test(this.data.account) || /@/.test(this.data.account))) {
      wx.showToast({ title: '请输入邮箱或手机号', icon: 'none' })
      return
    }
    this.handleSendCodeRequest()
  },
  handleSendCodeRequest() {
    this.setData({ disabled: true })
    // 开始倒计时
    const countdown = this.selectComponent('.countdown')
    countdown.start()
    api
      .sendCode({ account: this.data.account })
      .then(response => {
        const { code, msg } = response
        if (code === 0) {
          wx.showToast({ title: '验证码发送成功', icon: 'none' })
        } else {
          countdown.reset()
          this.setData({ disabled: false })
          wx.showToast({ title: msg, icon: 'none' })
        }
      })
      .catch(response => {
        countdown.reset()
        this.setData({ disabled: false })
      })
  }
})
