/**
 * 所有相关配置项
 */
const url_test = {
  URL_PATH1: 'https://wechat-api2.ezijing.com/api/lms', // 正式域名 - 由于项目变动域名
  URL_PATH2: 'https://wechat-api2.ezijing.com/api', // 正式域名 - 由于项目变动域名
  outSiteLink: 'https://e-learning.ezijing.com', // 正式外链
  tenant: 'caas',
  version: '3.2.5'
}
const url_online = {
  URL_PATH1: 'https://wechat-api.ezijing.com/api/lms', // 正式域名 - 由于项目变动域名
  URL_PATH2: 'https://wechat-api.ezijing.com/api', // 正式域名 - 由于项目变动域名
  outSiteLink: 'https://e-learning.ezijing.com', // 正式外链
  tenant: 'caas',
  version: '3.2.5'
}
let config = url_online
/* 请求接口统一 重定义 */
const requestApi = obj => {
  const token = wx.getStorageSync('token')
  if (!token) {
    wx.reLaunch({ url: '/pages/login/index' })
    return
  }

  wx.request({
    url: obj.url,
    data: obj.data || '', // 不必填
    header: {
      token,
      tenant: config.tenant,
      'content-type': 'application/x-www-form-urlencoded',
      version: config.version
    },
    method: obj.method || 'GET', // 不必填，默认 GET
    dataType: 'json',
    success: function (res) {
      if (res.statusCode === 200) {
        // if (res.data.status === 200) {
        //   obj.callback(res.data) // 直接把数据处理好，然后直接 返回
        // } else {
        //   wx.showToast({ title: JSON.stringify(res.data), icon: 'none' }) // 自己后台封装返回
        // }
        obj.callback(res)
      } else if (res.statusCode === 403 || res.statusCode === 401) {
        /* 未授权登录，跳转首页 */
        wx.reLaunch({
          url: '/pages/login/index'
        })
      } else {
        wx.showToast({ title: res.errMsg, icon: 'none' }) // 微信封装返回
      }
    },
    fail: function (res) {
      wx.showToast({ title: JSON.stringify(res), icon: 'none' })
    }
  })
}
/* 工具方法 - 播放时间 转化 h:m:s */
const durationToTimeString = duration => {
  let h = Math.floor(duration / 3600)
  let m = Math.floor((duration - h * 3600) / 60)
  let s = (duration - h * 3600 - m * 60) % 60
  function tenify(a) {
    return a >= 10 ? a : '0' + a
  }
  let to = { h: tenify(h), m: tenify(m), s: tenify(s) }
  let format = 'h:m:s'
  return format.replace(/h|m|s/g, k => to[k]).replace(/^00\:/, '')
}

/**
 * localStorage 中存放的 各种值
 * userSession - 调用 login 获取对应的 sessionKey openId等值
 * userInfo - 存放用户 头像、昵称等基本信息值
 *
 * videoCacheCtrlBar
 * audioCacheCtrlBar
 */

// 补零
const formatNumber = n => {
  n = n.toString()
  return n[1] ? n : '0' + n
}
// 秒转时间
const secondToTime = second => {
  const h = Math.floor(second / 3600)
  const m = Math.floor((second / 60) % 60)
  const s = Math.floor(second % 60)
  if (h) {
    return `${formatNumber(h)}:${formatNumber(m)}:${formatNumber(s)}`
  } else {
    return `${formatNumber(m)}:${formatNumber(s)}`
  }
}

module.exports = {
  config: config,
  requestApi: requestApi,
  durationToTimeString: durationToTimeString,
  formatNumber,
  secondToTime
}
