import httpRequest from '@/utils/axios'

// 登录
export function login(data) {
  return httpRequest.post('/api/passport/rest/login', data)
}
// 绑定微信
export function bindWechat(data) {
  return httpRequest.post('/api/passport/rest/wechat/bind-unionid', data)
}
// 登出
export function logout() {
  return httpRequest.get('/api/passport/rest/logout')
}
// 获取用户信息
export function getUser() {
  return httpRequest.get('/api/passport/account/get-user-info')
}

// 注册
export function register(data) {
  return httpRequest.post('/api/usercenter/user/register', data)
}
// 发送验证码
export function sendCode(data) {
  return httpRequest.post('/api/usercenter/user/send-code', data)
}
// 重置密码
export function resetPassword(data) {
  return httpRequest.post('/api/usercenter/user/update-pwd', data)
}
