const loginAccount = () => import(/* webpackChunkName: "login" */ '@/components/loginAccount.vue')
const loginCode = () => import(/* webpackChunkName: "login" */ '@/components/loginCode.vue')
const password = () => import(/* webpackChunkName: "login" */ '@/components/password.vue')
const register = () => import(/* webpackChunkName: "login" */ '@/components/register.vue')

export default [
  { path: '*', redirect: '/auth' },
  // 通用
  {
    path: '/auth',
    component: () => import(/* webpackChunkName: "auth" */ '../pages/auth/components/layout.vue'),
    children: [
      { path: '', redirect: 'login/index' },
      {
        path: 'login',
        component: () => import(/* webpackChunkName: "auth" */ '../pages/auth/login.vue'),
        children: [
          { path: '', redirect: 'index' },
          { path: 'index', component: loginAccount },
          { path: 'code', component: loginCode }
        ]
      },
      {
        path: 'password',
        component: () => import(/* webpackChunkName: "auth" */ '../pages/auth/password.vue'),
        children: [{ path: '', component: password }]
      },
      {
        path: 'register',
        component: () => import(/* webpackChunkName: "auth" */ '../pages/auth/register.vue'),
        children: [{ path: '', component: register }]
      }
    ]
  },
  // sofia
  {
    path: '/sofia',
    component: () => import(/* webpackChunkName: "sofia" */ '../pages/sofia/components/layout.vue'),
    children: [
      { path: '', redirect: 'login/index' },
      {
        path: 'login',
        component: () => import(/* webpackChunkName: "sofia" */ '../pages/sofia/login.vue'),
        children: [
          { path: '', redirect: 'index' },
          { path: 'index', component: loginAccount },
          { path: 'code', component: loginCode }
        ]
      },
      {
        path: 'password',
        component: () => import(/* webpackChunkName: "sofia" */ '../pages/sofia/password.vue'),
        children: [{ path: '', component: password }]
      }
    ]
  },
  // kelley
  {
    path: '/kelley',
    component: () => import(/* webpackChunkName: "kelley" */ '../pages/kelley/components/layout.vue'),
    children: [
      { path: '', redirect: 'login/index' },
      {
        path: 'login',
        component: () => import(/* webpackChunkName: "kelley" */ '../pages/kelley/login.vue'),
        children: [
          { path: '', redirect: 'index' },
          { path: 'index', component: loginAccount },
          { path: 'code', component: loginCode }
        ]
      },
      {
        path: 'password',
        component: () => import(/* webpackChunkName: "kelley" */ '../pages/kelley/password.vue'),
        children: [{ path: '', component: password }]
      }
    ]
  },
  // wmp
  {
    path: '/wmp',
    component: () => import(/* webpackChunkName: "wmp" */ '../pages/wmp/components/layout.vue'),
    children: [
      { path: '', redirect: 'login/index' },
      {
        path: 'login',
        component: () => import(/* webpackChunkName: "wmp" */ '../pages/wmp/login.vue'),
        children: [
          { path: '', redirect: 'index' },
          { path: 'index', component: loginAccount },
          { path: 'code', component: loginCode, props: { sendcode: { signName: 'wmp', template: 'SMS_200181319' } } }
        ]
      },
      {
        path: 'password',
        component: () => import(/* webpackChunkName: "wmp" */ '../pages/wmp/password.vue'),
        children: [
          { path: '', component: password, props: { sendcode: { signName: 'wmp', template: 'SMS_200191908' } } }
        ]
      },
      {
        path: 'register',
        component: () => import(/* webpackChunkName: "wmp" */ '../pages/wmp/register.vue')
      }
    ]
  },
  // bluestar
  {
    path: '/bluestar',
    component: () => import(/* webpackChunkName: "bluestar" */ '../pages/bluestar/components/layout.vue'),
    children: [
      { path: '', redirect: 'login/index' },
      {
        path: 'login',
        component: () => import(/* webpackChunkName: "bluestar" */ '../pages/bluestar/login.vue'),
        children: [
          { path: '', redirect: 'index' },
          { path: 'index', component: loginAccount },
          { path: 'code', component: loginCode }
        ]
      },
      {
        path: 'password',
        component: () => import(/* webpackChunkName: "bluestar" */ '../pages/bluestar/password.vue'),
        children: [{ path: '', component: password }]
      }
    ]
  },
  // ecollage
  {
    path: '/ecollage',
    component: () => import(/* webpackChunkName: "ecollage" */ '../pages/ecollage/components/layout.vue'),
    children: [
      { path: '', redirect: 'login/index' },
      {
        path: 'login',
        component: () => import(/* webpackChunkName: "ecollage" */ '../pages/ecollage/login.vue'),
        children: [
          { path: '', redirect: 'index' },
          { path: 'index', component: loginAccount },
          { path: 'code', component: loginCode }
        ]
      },
      {
        path: 'password',
        component: () => import(/* webpackChunkName: "ecollage" */ '../pages/ecollage/password.vue'),
        children: [{ path: '', component: password }]
      }
    ]
  },
  // enterprise
  {
    path: '/enterprise',
    component: () => import(/* webpackChunkName: "enterprise" */ '../pages/enterprise/components/layout.vue'),
    children: [
      { path: '', redirect: 'login/index' },
      {
        path: 'login',
        component: () => import(/* webpackChunkName: "enterprise" */ '../pages/enterprise/login.vue'),
        children: [
          { path: '', redirect: 'index' },
          { path: 'index', component: loginAccount },
          { path: 'code', component: loginCode }
        ]
      },
      {
        path: 'password',
        component: () => import(/* webpackChunkName: "enterprise" */ '../pages/enterprise/password.vue'),
        children: [{ path: '', component: password }]
      }
    ]
  },
  // demo
  {
    path: '/demo',
    component: () => import(/* webpackChunkName: "demo" */ '../pages/demo/components/layout.vue'),
    children: [
      { path: '', redirect: 'login/index' },
      {
        path: 'login',
        component: () => import(/* webpackChunkName: "demo" */ '../pages/demo/login.vue'),
        children: [
          { path: '', redirect: 'index' },
          { path: 'index', component: loginAccount },
          { path: 'code', component: loginCode }
        ]
      },
      {
        path: 'password',
        component: () => import(/* webpackChunkName: "demo" */ '../pages/demo/password.vue'),
        children: [{ path: '', component: password }]
      }
    ]
  },
  // seg
  {
    path: '/seg',
    component: () => import(/* webpackChunkName: "seg" */ '../pages/seg/components/layout.vue'),
    children: [
      { path: '', redirect: 'login/index' },
      {
        path: 'login',
        component: () => import(/* webpackChunkName: "seg" */ '../pages/seg/login.vue'),
        children: [
          { path: '', redirect: 'index' },
          { path: 'index', component: loginAccount },
          { path: 'code', component: loginCode }
        ]
      },
      {
        path: 'password',
        component: () => import(/* webpackChunkName: "seg" */ '../pages/seg/password.vue'),
        children: [{ path: '', component: password }]
      }
    ]
  },
  // ciis
  {
    path: '/ciis',
    component: () => import(/* webpackChunkName: "ciis" */ '../pages/ciis/components/layout.vue'),
    children: [
      { path: '', redirect: 'login/index' },
      {
        path: 'login',
        component: () => import(/* webpackChunkName: "ciis" */ '../pages/ciis/login.vue'),
        children: [
          { path: '', redirect: 'index' },
          { path: 'index', component: loginAccount },
          { path: 'code', component: loginCode }
        ]
      },
      {
        path: 'password',
        component: () => import(/* webpackChunkName: "ciis" */ '../pages/ciis/password.vue'),
        children: [{ path: '', component: password }]
      }
    ]
  },
  // campbellsville
  {
    path: '/campbellsville',
    component: () => import(/* webpackChunkName: "campbellsville" */ '../pages/campbellsville/components/layout.vue'),
    children: [
      { path: '', redirect: 'login/index' },
      {
        path: 'login',
        component: () => import(/* webpackChunkName: "campbellsville" */ '../pages/campbellsville/login.vue'),
        children: [
          { path: '', redirect: 'index' },
          { path: 'index', component: loginAccount },
          { path: 'code', component: loginCode }
        ]
      },
      {
        path: 'password',
        component: () => import(/* webpackChunkName: "campbellsville" */ '../pages/campbellsville/password.vue'),
        children: [{ path: '', component: password }]
      }
    ]
  }
]
