import httpRequest from '@/utils/axios'

// 登录
export function login(data, options) {
  return httpRequest.post('/api/passport/rest/login', data, options)
}
// 绑定微信
export function bindWechat(data, options) {
  return httpRequest.post('/api/passport/rest/wechat/bind-unionid', data, options)
}
// 登出
export function logout(options) {
  return httpRequest.get('/api/passport/rest/logout', options)
}
// 获取用户信息
export function getUser(options) {
  return httpRequest.get('/api/passport/account/get-user-info', options)
}
// 注册
export function register(data, options) {
  return httpRequest.post('/api/usercenter/user/register', data, options)
}
// 发送验证码
export function sendCode(data, options) {
  return httpRequest.post('/api/usercenter/user/send-code', data, options)
}
// 重置密码
export function resetPassword(data, options) {
  return httpRequest.post('/api/usercenter/user/update-pwd', data, options)
}
// 1+x注册
export function xlmsRegister(data) {
  return httpRequest.post('/api/zy/user/register', data, { headers: { tenant: 'x1' } })
}
// 获取学校
export function getSchool() {
  return httpRequest.get('/api/zy/user/school-list', { headers: { tenant: 'x1' } })
}
// 修改用户信息
export function updateUser(data) {
  return httpRequest.post('/api/usercenter/user/update-user', data)
}
