import fs from 'node:fs'
import path from 'node:path'
import { fileURLToPath, URL } from 'node:url'

import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue'
import AutoImport from 'unplugin-auto-import/vite'

export default defineConfig(({ mode }) => ({
  base: mode === 'prod' ? 'https://webapp-pub.ezijing.com/website/prod/project-online-fi/' : '/',
  plugins: [
    vue({ reactivityTransform: true }),
    AutoImport({
      imports: ['vue', 'vue/macros', 'vue-router', '@vueuse/core', '@vueuse/math'],
      dts: true,
      eslintrc: { enabled: true }
    })
  ],
  server: {
    open: true,
    host: 'dev.ezijing.com',
    https: {
      key: fs.readFileSync(path.join(__dirname, './https/dev.ezijing.com.key')),
      cert: fs.readFileSync(path.join(__dirname, './https/dev.ezijing.com.pem'))
    },
    proxy: {
      '/api': 'https://project-api.ezijing.com'
    }
  },
  resolve: {
    alias: {
      '@': fileURLToPath(new URL('./src', import.meta.url))
    }
  }
}))
