import { defineStore } from 'pinia'
import { useUserStore } from './user'
interface ShopFilter {
  label: string
  value: string
  courseList: any
}
type ShopListItem = Record<string, any>

export const useShopStore = defineStore('shop', () => {
  const route = useRoute()
  const userStore = useUserStore()
  // 筛选列表
  const filters = ref<ShopFilter[]>((window as any).SHOP.SHOP_FILTERS)
  // 商品列表
  const list = ref<ShopListItem[]>((window as any).SHOP.SHOP_LIST)

  // 计算后的商品列表，是否购买
  const shopList = computed<ShopListItem[]>(() => {
    return list.value.map(item => {
      const isBuy = !!userStore.courses.find((course: any) => course.course_id === item.course_id)
      return { ...item, isBuy }
    })
  })

  // 详情页面的单个商品
  const shopItem = computed(() => {
    const found = shopList.value.find(item => item.id === route.params.id)
    if (found) {
      found.course_list =
        found.child_ids && found.child_ids.length
          ? found.child_ids.map((id: string) => shopList.value.find(item => item.id === id))
          : shopList.value.filter(item => item.child_ids?.includes(found.id))
    }
    return found
  })

  // 相关推荐商品列表
  const shopRelatedList = computed(() => {
    return shopList.value.filter(item => item.category !== shopItem.value?.category && item.type==='课程包')
  })

  const shopRelatedListOther = computed(() => {
    return shopList.value.filter(
      (item: ShopListItem) => item.category === shopItem.value?.category && item.id !== shopItem.value?.id && item.type=== '课程'
    )
  })

  return { filters, list, shopList, shopItem, shopRelatedList, shopRelatedListOther }
})
