import httpRequest from './axios'

export default function useWXShare(data) {
  const shareData = Object.assign(
    {
      title: '清控紫荆金保',
      desc: '教育、科技、人才！努力建设成为国际卓越的金融保险平台',
      link: location.href,
      imgUrl: 'https://webapp-pub.ezijing.com/project_online/fi/logo.png'
    },
    data
  )

  const updateShareData = () => {
    wx.updateAppMessageShareData({
      title: shareData.title,
      desc: shareData.desc,
      link: shareData.link,
      imgUrl: shareData.imgUrl
    })

    wx.updateTimelineShareData({
      title: shareData.title,
      link: shareData.link,
      imgUrl: shareData.imgUrl
    })
  }

  httpRequest
    .post(
      'https://node-server.ezijing.com/share/getsignature',
      {
        appId: 'wxfe67f37095e08d2f',
        url: location.href.split('#').pop()
      },
      {
        headers: {
          'Content-Type': 'application/x-www-form-urlencoded'
        }
      }
    )
    .then(result => {
      wx.config({
        debug: false, // 开启调试模式,调用的所有api的返回值会在客户端alert出来，若要查看传入的参数，可以在pc端打开，参数信息会通过log打出，仅在pc端时才会打印。
        appId: 'wxfe67f37095e08d2f', // 必填，公众号的唯一标识
        timestamp: result.timestamp, // 必填，生成签名的时间戳
        nonceStr: result.noncestr, // 必填，生成签名的随机串
        signature: result.token, // 必填，签名
        jsApiList: ['updateAppMessageShareData', 'updateTimelineShareData'] // 必填，需要使用的JS接口列表
      })
      wx.ready(updateShareData)
    })
}
