import { createApp } from 'vue'
import { createPinia } from 'pinia'

import App from './App.vue'
import router from './router'

import ElementPlus from 'element-plus'
import 'element-plus/dist/index.css'
import { Overlay, Tab, Tabs, ActionSheet } from 'vant'
// 2. 引入组件样式
import 'vant/lib/index.css'
// 公共css
import './assets/css/base.css'
// 公共组件
import AppCard from '@/components/base/AppCard.vue'
import AppContainer from '@/components/base/AppContainer.vue'

import modules from './modules'
import useWXShare from '@/utils/wx'

const app = createApp(App)
// 注册公共组件
app.component('AppCard', AppCard).component('AppContainer', AppContainer)

// 注册模块
modules({ router })

app.use(createPinia())
app.use(Overlay)
app.use(ActionSheet)
app.use(Tab)
app.use(Tabs)
app.use(router)
app.use(ElementPlus)

app.mount('#app')
useWXShare()
