import httpRequest from '@/utils/axios'

/**
 * 创建订单
 * */
export function createOrder(data?: any) {
  return httpRequest.post('https://shop-show-pc.ezijing.com/api/shop/order/add', data)
}

/**
 * 获取订单
 * */
export function getOrderList(data?: any) {
  return httpRequest.post('https://shop-show-pc.ezijing.com/api/shop/order/search', data)
}

/**
 * 获取用户OpenId
 * */
export function getOpenId(data?: any) {
  return httpRequest.post('https://shop-show-pc.ezijing.com/api/usercenter/v1/wechat/get-openid', data, {
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
  })
}
