import { defineStore } from 'pinia'
import { useUserStore } from './user'
interface ShopFilter {
  label: string
  value: string
  children?: any
  courseList: any
  isActive?: boolean
}
type ShopListItem = Record<string, any>

export const useShopStore = defineStore('shop', () => {
  const route = useRoute()
  const userStore = useUserStore()
  // 筛选列表
  const filters = ref<ShopFilter[]>((window as any).SHOP.SHOP_FILTERS)
  // 商品列表
  const list = ref<ShopListItem[]>((window as any).SHOP.SHOP_LIST)

  // 计算后的商品列表，是否购买
  const shopList = computed<ShopListItem[]>(() => {
    return list.value.map(item => {
      const isBuy = !!userStore.courses.find((course: any) => course.course_id === item.course_id)
      return { ...item, isBuy }
    })
  })

  // 详情页面的单个商品
  const shopItem = computed(() => {
    const found = shopList.value.find(item => item.id === route.params.id)
    if (found) {
      found.course_list =
        found.child_ids && found.child_ids.length
          ? found.child_ids
              .map((id: string) => shopList.value.find(item => item.id === id))
              .filter((it: any) => !it.is_test)
          : shopList.value.filter(item => item.child_ids?.includes(found.id)).filter(it => !it.is_test)
    }
    return found
  })

  // 相关推荐商品列表
  const shopRelatedList = computed(() => {
    const list = shopList.value.filter(
      item => item.type === shopItem.value?.type && !item.is_test && item.id !== shopItem.value?.id
    )
    return shopItem.value?.type === '课程包' ? list : list.filter(item => item.category === shopItem.value?.category)
  })

  return { filters, list, shopList, shopItem, shopRelatedList }
})
