export function useDevice() {
  const navigator = window.navigator

  const userAgent = ref(navigator.userAgent)

  const mobile = computed(() => {
    return /iphone/i.test(userAgent.value) || (/android/i.test(userAgent.value) && /mobile/i.test(userAgent.value))
  })

  const wechat = computed(() => {
    return /micromessenger/i.test(userAgent.value)
  })

  const alipay = computed(() => {
    return /alipayclient/i.test(userAgent.value)
  })

  addEventListener('resize', () => {
    if (navigator) userAgent.value = navigator.userAgent
  })

  return { userAgent, mobile, wechat, alipay }
}
