import httpRequest from '@/utils/axios'

// 获取用户信息
export function getUser() {
  return httpRequest.get('/api/passport/account/get-user-info')
}

// 退出登录
export function logout() {
  return httpRequest.get('/api/passport/rest/logout')
}

// 获取oss token
export function getToken() {
  return httpRequest.get('/api/usercenter/aliyun/assume-role')
}

// 获取oss signature
export function getSignature() {
  return httpRequest.get('/api/usercenter/aliyun/get-signature')
}

// 图片上传
export function uploadFile(data: object) {
  return httpRequest.post('https://webapp-pub.oss-cn-beijing.aliyuncs.com', data, {
    withCredentials: false,
    headers: { 'Content-Type': 'multipart/form-data' }
  })
}

// 获取已经购买的课程
export function getBuyShop() {
  return httpRequest.get('https://learn-api.ezijing.com/api/lms-ep/v2/education/courses/my', {
    headers: { tenant: 'paa' }
  })
}
