import { defineStore } from 'pinia'
// import { useUserStore } from './user'
// const { courses } = useUserStore()
interface ShopFilter {
  label: string
  value: string
  courseList: any
}
type ShopListItem = Record<string, any>

interface State {
  filters: ShopFilter[]
  list: ShopListItem[]
}

export const useShopStore = defineStore({
  id: 'shop',
  state: (): State => ({
    filters: (window as any).SHOP.SHOP_FILTERS, // 筛选列表
    list: (window as any).SHOP.SHOP_LIST // 商品列表
  }),
  getters: {
    shopList({ list }) {
      return list.map(item => {
        // const { courses } = useUserStore()
        const courses = JSON.parse(localStorage.getItem('courses') as string)
        item.isBuy = !!courses.find((course: any) => course.course_id === item.course_id)
        return item
      })
    },
    shopItem(): ShopListItem | undefined {
      const route = useRoute()
      const found = this.shopList.find(item => item.id === route.params.id)
      if (found) {
        found.course_list =
          found.child_ids && found.child_ids.length
            ? found.child_ids.map((id: string) => this.shopList.find(item => item.id === id))
            : this.shopList.filter(item => item.child_ids?.includes(found.id))
      }
      return found
    },
    shopRelatedList(): ShopListItem[] {
      return this.shopList.filter((item: ShopListItem) => item.category !== this.shopItem?.category)
    },
    shopRelatedListOther(): ShopListItem[] {
      return this.shopList.filter(
        (item: ShopListItem) => item.category === this.shopItem?.category && item.id !== this.shopItem?.id
      )
    }
  },
  actions: {
    // async getShopList() {
    //   const shop = await import('https://webapp-pub.ezijing.com/project_online/fi/shop.js')
    //   console.log(shop)
    // }
  }
})
