import { defineStore } from 'pinia'
import { getUser, logout, getBuyShop } from '@/api/base'

import type { UserState } from '@/types'
interface State {
  user: UserState | null
  courses: any
}
export const useUserStore = defineStore({
  id: 'user',
  state: (): State => ({
    user: null,
    courses: [] || JSON.parse(localStorage.getItem('courses') as string)
  }),
  getters: {
    isLogin: state => !!state.user,
    userName: ({ user }) => {
      if (!user) return ''
      return user.realname || user.nickname || user.username || ''
    },
    mobile: ({ user }) => {
      if (!user) return ''
      return user.mobile
    }
  },
  actions: {
    async getUser() {
      const res = await getUser()
      try {
        this.courses = await getBuyShop()
        localStorage.setItem('courses', JSON.stringify(this.courses))
      } catch (error) {
        console.log(error)
      }
      this.user = res.data
    },

    async logout() {
      await logout()
      this.user = null
    }
  }
})
