import { defineStore } from 'pinia'

interface ShopFilter {
  label: string
  value: string
}
type ShopListItem = Record<string, any>

interface State {
  filters: ShopFilter[]
  list: ShopListItem[]
}

export const useShopStore = defineStore({
  id: 'shop',
  state: (): State => ({
    filters: (window as any).SHOP.SHOP_FILTERS, // 筛选列表
    list: (window as any).SHOP.SHOP_LIST // 商品列表
  }),
  getters: {
    shopItem({ list }) {
      const route = useRoute()
      const found = list.find(item => item.id === route.params.id)
      if (found) {
        found.course_list =
          found.child_ids && found.child_ids.length
            ? found.child_ids.map((id: string) => list.find(item => item.id === id))
            : list.filter(item => item.child_ids?.includes(found.id))
      }
      return found
    },
    relatedShopList({ list }): ShopListItem[] {
      return list.filter((item: ShopListItem) => item.category !== this.shopItem?.category)
    }
  },
  actions: {
    // async getShopList() {
    //   const shop = await import('https://webapp-pub.ezijing.com/project_online/fi/shop.js')
    //   console.log(shop)
    // }
  }
})
