import { createApp } from 'vue'
import { createPinia } from 'pinia'

import App from './App.vue'
import router from './router'

import ElementPlus from 'element-plus'
import 'element-plus/dist/index.css'

// 公共css
import './assets/css/base.css'
// 公共组件
import AppCard from '@/components/base/AppCard.vue'
import AppContainer from '@/components/base/AppContainer.vue'

import modules from './modules'

const app = createApp(App)
// 注册公共组件
app.component('AppCard', AppCard).component('AppContainer', AppContainer)

// 注册模块
modules({ router })

app.use(createPinia())
app.use(router)
app.use(ElementPlus)

app.mount('#app')
