import { defineStore } from 'pinia'

interface ShopFilter {
  label: string
  value: string
}
type ShopListItem = Record<string, any>

interface State {
  filters: ShopFilter[]
  list: ShopListItem[]
}

export const useShopStore = defineStore({
  id: 'shop',
  state: (): State => ({
    filters: (window as any).SHOP.SHOP_FILTERS, // 筛选列表
    list: (window as any).SHOP.SHOP_LIST // 商品列表
  }),
  getters: {
    shopItem: ({ list }) => {
      const route = useRoute()
      console.log(list)
      return list.find(item => item.id === route.params.id)
    }
  },
  actions: {
    // async getShopList() {
    //   const shop = await import('https://webapp-pub.ezijing.com/project_online/fi/shop.js')
    //   console.log(shop)
    // }
  }
})
