import { createRouter, createWebHistory } from 'vue-router'
import { useUserStore } from '@/stores/user'

const router = createRouter({
  scrollBehavior(to) {
    if (to.hash) {
      return { el: to.hash, top: 94 }
    }
    // 始终滚动到顶部
    return { top: 0 }
  },
  history: createWebHistory(),
  routes: [{ path: '/:pathMatch(.*)*', redirect: '/home' }]
})

router.beforeEach(async (to, from, next) => {
  const user = useUserStore()
  if (to.meta.loginRequired && !user.isLogin) {
    try {
      await user.getUser()
    } catch (e) {
      console.error(e)
    }
    if (!user.isLogin) {
      location.href = `${import.meta.env.VITE_LOGIN_URL}?rd=${encodeURIComponent(location.href)}`
      return
    }
  }
  next()
})

export default router
