import type { Router } from 'vue-router'
import type { AppModule } from '@/types'

export default function ({ router }: { router: Router }) {
  const modules: Array<AppModule> = Object.values(import.meta.glob('./**/index.ts', { eager: true }))
  modules.forEach(({ routes = [] }) => {
    // 注册路由
    routes.forEach(route => {
      router.addRoute(route)
    })
  })
}
