import axios from 'axios'

const httpRequest = axios.create({
  baseURL: 'https://learn-api.ezijing.com',
  timeout: 60000,
  withCredentials: true
})

// 响应拦截
httpRequest.interceptors.response.use(
  function (response) {
    const { data } = response
    if (data.code === undefined) {
      return data
    }
    // 正常返回
    if (data.code === 0) {
      return data
    }
    // 未登录
    if (data.code === 4001) {
      location.href = `${import.meta.env.VITE_LOGIN_URL}?rd=${encodeURIComponent(location.href)}`
    }
    return Promise.reject(data)
  },
  function (error) {
    if (error.response) {
      const { status, message } = error.response.data
      // 未登录
      if (status === 403) {
        location.href = `${import.meta.env.VITE_LOGIN_URL}?rd=${encodeURIComponent(location.href)}`
      } else {
        console.error(`${status}: ${message}`)
      }
    } else {
      console.log(error)
    }
    return Promise.reject(error.response || error)
  }
)

export default httpRequest
