import { createApp } from 'vue'
import { createPinia } from 'pinia'

import App from './App.vue'
import router from './router'

import ElementPlus from 'element-plus'
import 'element-plus/dist/index.css'

import { Overlay } from 'vant';
// 2. 引入组件样式
import 'vant/lib/index.css';
import Vconsole from 'vconsole'

// 公共css
import './assets/css/base.css'
// 公共组件
import AppCard from '@/components/base/AppCard.vue'
import AppContainer from '@/components/base/AppContainer.vue'

import modules from './modules'
 
const vConsole = new Vconsole()
const app = createApp(App)



// 注册公共组件
app.component('AppCard', AppCard).component('AppContainer', AppContainer)

// 注册模块
modules({ router })
app.use(Overlay)
app.use(createPinia())
app.use(router)
app.use(ElementPlus)
app.use(vConsole)
app.mount('#app')
