import { defineStore } from 'pinia'
import { getUser, logout } from '@/api/base'

import type { UserState } from '@/types'

interface State {
  user: UserState | null
}
export const useUserStore = defineStore({
  id: 'user',
  state: (): State => ({
    user: null
  }),
  getters: {
    isLogin: state => !!state.user,
    userName: ({ user }) => {
      if (!user) return ''
      return user.realname || user.nickname || user.username || ''
    }
  },
  actions: {
    async getUser() {
      const res = await getUser()
      this.user = res.data
    },
    async logout() {
      await logout()
      this.user = null
    }
  }
})
